/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.events.cards;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wolforce.mctcg.MCTCG;
import wolforce.mctcg.util.Attributes;
import wolforce.mctcg.util.Util;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventsActions {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        Attributes attributes = new Attributes(player);
        if (attributes.isEmpty() || player.field_70170_p.field_72995_K) {
            return;
        }
        BlockState state = event.getState();
        Block block = state.func_177230_c();
        World world = player.field_70170_p;
        BlockPos pos = event.getPos();
        Vector3d centerPos = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        boolean b = EventsActions.onBlockBreakIsCanceled(event, world, block, state, pos, centerPos, attributes);
        if (event.isCancelable() && b) {
            event.setCanceled(true);
            world.func_217377_a(pos, false);
        }
    }

    public static boolean onBlockBreakIsCanceled(BlockEvent.BreakEvent event, World world, Block block, BlockState state, BlockPos pos, Vector3d centerPos, Attributes attributes) {
        int value;
        int val;
        if (block == Blocks.field_150348_b && attributes.get(MCTCG.action_earth_alchemy) > 0) {
            double a = Math.random();
            if (a > 0.95) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Blocks.field_196656_g));
            } else if (a > 0.9) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Blocks.field_196654_e));
            }
            if (!(a > 0.85)) {
                return false;
            }
            Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Blocks.field_196650_c));
            return true;
        }
        if (block == Blocks.field_150365_q) {
            int val2 = attributes.get(MCTCG.action_diamond_prospector);
            if (val2 > 0 && Math.random() < 0.005 * (double)val2) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_151045_i));
            }
            return false;
        }
        if (block == Blocks.field_150348_b && (val = attributes.get(MCTCG.action_vanishing_point)) > 0 && Math.random() < 0.5) {
            return true;
        }
        if (block == Blocks.field_150366_p) {
            val = attributes.get(MCTCG.action_gold_prospector);
            if (val > 0 && Math.random() < 0.1 * (double)val) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_151074_bl, 1 + (int)(Math.random() * 2.0)));
            }
            return false;
        }
        if (block == Blocks.field_150369_x) {
            val = attributes.get(MCTCG.action_lapis_prospector);
            if (val > 0 && Math.random() < 0.1 * (double)val) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_196128_bn, 1 + (int)(Math.random() * 3.0)));
            }
            return false;
        }
        if (block == Blocks.field_150450_ax) {
            val = attributes.get(MCTCG.action_redstone_prospector);
            if (val > 0 && Math.random() < 0.1 * (double)val) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_151137_ax, 1 + (int)(Math.random() * 3.0)));
            }
            return false;
        }
        if (block == Blocks.field_196766_fg) {
            val = attributes.get(MCTCG.action_quartz_prospector);
            if (val > 0 && Math.random() < 0.1 * (double)val) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_151128_bU, 1 + (int)(Math.random() * 3.0)));
            }
            return false;
        }
        if (block == Blocks.field_150346_d) {
            val = attributes.get(MCTCG.action_argil_pursuit);
            if (val > 0 && Math.random() < 0.1 * (double)val && Util.blockIsNearBlock(world, pos, Blocks.field_150355_j)) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_151119_aD));
            }
            return false;
        }
        if (block instanceof LeavesBlock && ((value = attributes.get(MCTCG.action_tree_lover)) == 1 && Math.random() < 0.1 || value >= 2 && Math.random() < 0.15)) {
            if (block == Blocks.field_196572_aa) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_221596_x));
            } else if (block == Blocks.field_196647_Y) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_221594_v));
            } else if (block == Blocks.field_196574_ab) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_221597_y));
            } else if (block == Blocks.field_196648_Z) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_221595_w));
            } else if (block == Blocks.field_196642_W) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_221592_t));
            } else if (block == Blocks.field_196645_X) {
                Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_221593_u));
            }
        }
        if (block == Blocks.field_150426_aN && attributes.has(MCTCG.action_gentle_glowstone)) {
            Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_151114_aO, 4));
            return true;
        }
        if (block == Blocks.field_150351_n && attributes.has(MCTCG.action_grit_love)) {
            Util.spawnItem(world, centerPos, new ItemStack((IItemProvider)Items.field_221550_C));
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        Attributes attributes = new Attributes(player);
        if (attributes.isEmpty()) {
            return;
        }
        if (attributes.has(MCTCG.action_feather_feet.regName) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent.Throwable event) {
        World world = event.getEntity().field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        ThrowableEntity entity = event.getThrowable();
        Entity _player = entity.func_234616_v_();
        if (!(_player instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)_player;
        Attributes attributes = new Attributes(player);
        if (attributes.isEmpty()) {
            return;
        }
        if (event.getThrowable() instanceof SnowballEntity) {
            BlockPos pos;
            if (attributes.get(MCTCG.action_snow_piles) > 0 && world.func_175623_d(pos = entity.func_233580_cy_()) && world.func_180495_p(pos.func_177977_b()).func_215682_a((IBlockReader)world, pos, (Entity)entity, Direction.UP)) {
                world.func_175656_a(pos, Blocks.field_150433_aE.func_176223_P());
            }
            return;
        }
        if (event.getThrowable() instanceof EnderPearlEntity) {
            if (attributes.get(MCTCG.action_ender_ways) > 0) {
                ItemEntity itemEntity = new ItemEntity(world, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                itemEntity.func_92058_a(new ItemStack((IItemProvider)Items.field_151079_bi));
                world.func_217376_c((Entity)itemEntity);
            }
            return;
        }
        if (event.getThrowable() instanceof EggEntity) {
            double prob = (double)attributes.get(MCTCG.action_fowl_play) * 0.33;
            if (Math.random() < prob) {
                ChickenEntity chickenEntity = (ChickenEntity)EntityType.field_200795_i.func_200721_a(entity.field_70170_p);
                chickenEntity.func_70873_a(-24000);
                chickenEntity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, 0.0f);
                player.field_70170_p.func_217376_c((Entity)chickenEntity);
                if (event.getRayTraceResult() instanceof EntityRayTraceResult) {
                    ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)entity, (Entity)entity.func_234616_v_()), 0.0f);
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
            return;
        }
    }

    @SubscribeEvent
    public static void onEntityRightClickBlock(final PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b().getItem() == Items.field_151131_as) {
            LivingEntity entity = event.getEntityLiving();
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            final PlayerEntity player = (PlayerEntity)entity;
            Attributes attributes = new Attributes(player);
            if (attributes.isEmpty()) {
                return;
            }
            int attr = attributes.get(MCTCG.action_carrying_water);
            if (attr == 0) {
                return;
            }
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(20L);
                        player.func_184611_a(event.getHand(), new ItemStack((IItemProvider)Items.field_151131_as));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.start();
        }
    }

    @SubscribeEvent
    public static void onLivingEntityDeath(LivingDeathEvent event) {
        int creeping_rush;
        int colourful_fins;
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        Entity source = event.getSource().func_76346_g();
        if (!(source instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)source;
        Entity entity = event.getEntity();
        Attributes attributes = new Attributes(player);
        if (attributes.isEmpty()) {
            return;
        }
        int calcium_mania = attributes.get(MCTCG.action_calcium_mania);
        if (calcium_mania > 0 && (entity instanceof ZombieEntity || event.getEntity() instanceof SpiderEntity) && Math.random() < 0.25 * (double)calcium_mania) {
            Util.spawnItem(player.field_70170_p, entity.func_213303_ch(), Math.random() < 0.2 ? new ItemStack((IItemProvider)Items.field_151103_aS, 2) : new ItemStack((IItemProvider)Items.field_151103_aS));
        }
        if ((colourful_fins = attributes.get(MCTCG.action_colourful_fins)) > 0 && entity instanceof TropicalFishEntity && Math.random() < 0.25 * (double)colourful_fins) {
            Util.spawnItem(player.field_70170_p, entity.func_213303_ch(), Math.random() < 0.2 ? new ItemStack(Util.randomDye(), 2) : new ItemStack(Util.randomDye()));
        }
        if ((creeping_rush = attributes.get(MCTCG.action_creeping_rush)) > 0 && entity instanceof CreeperEntity && Math.random() < 0.25 * (double)creeping_rush) {
            Util.spawnItem(player.field_70170_p, entity.func_213303_ch(), Math.random() < 0.2 ? new ItemStack((IItemProvider)Items.field_151102_aT, 2) : new ItemStack((IItemProvider)Items.field_151102_aT));
        }
    }

    public static void emptyBucket(Attributes attributes, ItemStack stack, PlayerEntity player, CallbackInfoReturnable<ItemStack> cir) {
        if (stack.func_77973_b() == Items.field_151131_as && attributes.has(MCTCG.action_carrying_water)) {
            cir.setReturnValue((Object)new ItemStack((IItemProvider)Items.field_151131_as));
        }
    }
}

