/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wolforce.mctcg.MCTCG;
import wolforce.mctcg.capabilities.CapabilityCoin;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventsCoins {
    @SubscribeEvent
    public static void attachEventCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("mctcg", "coin_cap"), (ICapabilityProvider)new CapabilityCoin.CoinCapProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath() || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        LazyOptional oldCoinCap = event.getOriginal().getCapability(CapabilityCoin.CAPABILITY);
        oldCoinCap.ifPresent(oldXP -> {
            LazyOptional newCoinCap = event.getPlayer().getCapability(CapabilityCoin.CAPABILITY);
            newCoinCap.ifPresent(newXP -> newXP.copyFrom((CapabilityCoin)oldXP));
        });
    }

    @SubscribeEvent
    public static void coinOnBlockBreak(BlockEvent.BreakEvent event) {
        EventsCoins.tryGetCoin(event.getPlayer(), event.getPos());
    }

    @SubscribeEvent
    public static void EntityPlaceEvent(BlockEvent.EntityPlaceEvent event) {
        PlayerEntity player;
        PlayerEntity playerEntity = player = event.getEntity() instanceof PlayerEntity ? (PlayerEntity)event.getEntity() : null;
        if (player != null) {
            EventsCoins.tryGetCoin(player, event.getPos());
        }
    }

    @SubscribeEvent
    public static void coinOnAnimalTamed(AnimalTameEvent event) {
        EventsCoins.tryGetCoin(event.getTamer(), event.getAnimal().func_226277_ct_(), event.getAnimal().func_226281_cx_(), event.getAnimal().func_226281_cx_(), 1.5);
    }

    @SubscribeEvent
    public static void coinOnItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        EventsCoins.tryGetCoin(event.getPlayer(), 0.8);
    }

    @SubscribeEvent
    public static void coinOnLevelUp(PlayerXpEvent.LevelChange event) {
        EventsCoins.tryGetCoin(event.getPlayer(), 10.0);
    }

    @SubscribeEvent
    public static void coinOnItemFished(ItemFishedEvent event) {
        EventsCoins.tryGetCoin(event.getPlayer(), 2.0);
    }

    @SubscribeEvent
    public static void coinOnAdvancement(AdvancementEvent event) {
        EventsCoins.tryGetCoin(event.getPlayer(), 10.0);
    }

    @SubscribeEvent
    public static void coinOnItemsSmelted(PlayerEvent.ItemSmeltedEvent event) {
        EventsCoins.tryGetCoin(event.getPlayer(), 1.5);
    }

    @SubscribeEvent
    public static void coinOnPotionBrewed(PlayerBrewedPotionEvent event) {
        EventsCoins.tryGetCoin(event.getPlayer(), 2.0);
    }

    @SubscribeEvent
    public static void coinOnPlayerWakeUp(PlayerWakeUpEvent event) {
        EventsCoins.tryGetCoin(event.getPlayer(), 3.0);
    }

    private static void tryGetCoin(PlayerEntity player, BlockPos pos) {
        if (player == null) {
            return;
        }
        EventsCoins.tryGetCoin(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.0);
    }

    private static void tryGetCoin(PlayerEntity player, double multiplier) {
        EventsCoins.tryGetCoin(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), multiplier);
    }

    private static void tryGetCoin(PlayerEntity player, double x, double y, double z, double multiplier) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        CapabilityCoin coinCap = CapabilityCoin.get(player);
        if (coinCap.willGetCoin(multiplier)) {
            coinCap.reset();
            coinCap.increaseCoinsReceived(1);
            player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, x, y, z, new ItemStack((IItemProvider)MCTCG.mctcg_coin)));
        }
    }
}

