/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.datagen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import wolforce.mctcg.MCTCG;
import wolforce.mctcg.items.ItemCard;
import wolforce.mctcg.util.Util;

public class DataGen {
    private static File itemModels = new File("src\\main\\resources\\assets\\mctcg\\models\\item");
    private static File itemTags = new File("src\\main\\resources\\data\\mctcg\\tags\\items");
    private static File cardsTags = new File("src\\main\\resources\\data\\mctcg\\tags\\items\\card");

    public static void main(String[] args) {
        MCTCG.dataGen = true;
        new MCTCG();
        for (ItemCard.EnumRarity rarity : MCTCG.cards.keySet()) {
            for (ItemCard card : MCTCG.cards.get((Object)rarity)) {
                DataGen.regCardModel(card);
            }
        }
        DataGen.regCardsTags();
        DataGen.randTest();
    }

    private static void randTest() {
        float i = -1.0f;
        while (i < 4.0f) {
            float j = -1.0f;
            while (j < 4.0f) {
                List<Integer> rarities = Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0, 0);
                List<Integer> types = Arrays.asList(0, 0, 0, 0, 0, 0, 0, 0, 0);
                for (int k = 0; k < 100000; ++k) {
                    ItemStack stack = MCTCG.getRandomCard(i, j);
                    if (!Util.isValid(stack)) continue;
                    ItemCard card = (ItemCard)stack.func_77973_b();
                    rarities.set(card.field_208075_l.ordinal(), rarities.get(card.field_208075_l.ordinal()) + 1);
                    types.set(card.type.ordinal(), types.get(card.type.ordinal()) + 1);
                }
                int ii = (int)(i * 10.0f);
                int jj = (int)(j * 10.0f);
                System.out.println("(" + ii + "," + jj + ") rarities:" + rarities);
                j = (float)((double)j + 0.5);
            }
            i = (float)((double)i + 0.1);
        }
    }

    private static void regCardsTags() {
        String regName;
        try {
            PrintWriter pw = new PrintWriter(new File(itemTags, "card.json"));
            pw.append("{\"replace\": false,\"values\": [");
            for (ItemCard.EnumRarity rarity : MCTCG.cards.keySet()) {
                if (rarity == ItemCard.EnumRarity.Rules) continue;
                for (ItemCard card : MCTCG.cards.get((Object)rarity)) {
                    regName = card.getRegistryName().func_110623_a();
                    pw.append("\"mctcg:" + regName + "\",\r\n");
                }
            }
            pw.append("\"mctcg:rules_card\"\r\n");
            pw.append("]}");
            pw.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (ItemCard.EnumRarity rarity : MCTCG.cards.keySet()) {
            try {
                PrintWriter pw = new PrintWriter(new File(cardsTags, rarity.name().toLowerCase() + ".json"));
                pw.append("{\"replace\": false,\"values\": [");
                if (rarity != ItemCard.EnumRarity.Rules) {
                    for (ItemCard card : MCTCG.cards.get((Object)rarity)) {
                        regName = card.getRegistryName().func_110623_a();
                        pw.append("\"mctcg:" + regName + "\",\r\n");
                    }
                }
                pw.append("\"mctcg:rules_card\"\r\n");
                pw.append("]}");
                pw.flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static void regCardModel(ItemCard card) {
        String regName = card.getRegistryName().func_110623_a();
        String name = "base_" + card.source.name().toLowerCase();
        try {
            PrintWriter pw = new PrintWriter(new File(itemModels, regName + ".json"));
            pw.append("{ \"parent\": \"mctcg:item/card_" + name + "\" }");
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("added item model for card: " + card.getRegistryName());
    }
}

