/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.container.tradingstation;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;
import wolforce.mctcg.MCTCG;
import wolforce.mctcg.container.ContainerWithDefaultPlayerInventory;
import wolforce.mctcg.util.Util;

public class ContainerTradingStation
extends ContainerWithDefaultPlayerInventory {
    public static final StringTextComponent TITLE = new StringTextComponent("Card Trading Table");
    public static final String CONTAINER_ID = "container_trading_station";
    @ObjectHolder(value="mctcg:container_trading_station")
    public static ContainerType<ContainerTradingStation> TYPE;
    private CoinStackHandler coinSlot = new CoinStackHandler();
    private BoosterStackHandler boosterSlot = new BoosterStackHandler();

    public ContainerTradingStation(int id, PlayerInventory playerInv, PacketBuffer extraData) {
        this(id, playerInv);
    }

    private ContainerTradingStation(int id, PlayerInventory playerInventory) {
        super(TYPE, id, playerInventory, 8, 62, (ITextComponent)TITLE, 2, ItemStack.field_190927_a);
        this.addSlotBox(0, 8, 39, (IItemHandler)this.coinSlot, 1, 1, -1, -1);
        this.addSlotBox(0, 152, 39, (IItemHandler)this.boosterSlot, 1, 1, -1, -1);
    }

    public int getNumberOfCoins() {
        if (!Util.isValid(this.coinSlot.getStackInSlot(0))) {
            return 0;
        }
        return this.coinSlot.getStackInSlot(0).func_190916_E();
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.keepIfValid(player, this.coinSlot.getStackInSlot(0));
    }

    public double getBoosterPackMinPercent(int nCoins) {
        double val = 0.0;
        for (int i = 0; i < nCoins; ++i) {
            val += i < 20 ? 0.1 : (i < 32 ? 0.04 : 0.01);
        }
        return val;
    }

    public double getBoosterPackMaxPercent(int nCoins) {
        double val = 0.0;
        for (int i = 0; i < nCoins; ++i) {
            val += i < 15 ? 0.05 : 0.02;
        }
        return 1.5 + val;
    }

    private CompoundNBT makeNbtForBoosterPack() {
        int nCoins = this.getNumberOfCoins();
        CompoundNBT tag = new CompoundNBT();
        tag.func_74780_a("min", this.getBoosterPackMinPercent(nCoins));
        tag.func_74780_a("max", this.getBoosterPackMaxPercent(nCoins));
        return tag;
    }

    public static SimpleNamedContainerProvider getServerContainerProvider(PlayerInventory playerInv) {
        IContainerProvider provider = (id, playerInventory, serverPlayer) -> new ContainerTradingStation(id, playerInv);
        return new SimpleNamedContainerProvider(provider, (ITextComponent)TITLE);
    }

    class BoosterStackHandler
    extends ItemStackHandler {
        public BoosterStackHandler() {
            super(1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack extracted = super.extractItem(slot, amount, simulate);
            extracted.func_77982_d(ContainerTradingStation.this.makeNbtForBoosterPack());
            if (!simulate) {
                ContainerTradingStation.this.coinSlot.setStackInSlot(0, ItemStack.field_190927_a);
            }
            return extracted;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            super.setStackInSlot(slot, stack);
        }

        public void setSize(int size) {
            super.setSize(size);
        }
    }

    class CoinStackHandler
    extends ItemStackHandler {
        public CoinStackHandler() {
            super(1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == MCTCG.mctcg_coin;
        }

        protected void onContentsChanged(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            ContainerTradingStation.this.boosterSlot.setStackInSlot(0, Util.isValid(stack) && stack.func_77973_b() == MCTCG.mctcg_coin ? new ItemStack((IItemProvider)MCTCG.booster_pack) : ItemStack.field_190927_a);
        }
    }
}

