/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.container.boosterpack;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;
import wolforce.mctcg.MCTCG;
import wolforce.mctcg.container.ContainerWithDefaultPlayerInventory;

public class ContainerBoosterPack
extends ContainerWithDefaultPlayerInventory {
    public static final String CONTAINER_BOOSTER_PACK = "container_boosterpack";
    private static final ITextComponent TITLE = new StringTextComponent("Booster Pack");
    @ObjectHolder(value="mctcg:container_boosterpack")
    public static ContainerType<ContainerBoosterPack> TYPE;
    private IItemHandler cardSlots = new ItemStackHandler(3);

    public ContainerBoosterPack(int id, PlayerInventory playerInv, PacketBuffer extraData) {
        this(id, playerInv, -1.0, -1.0);
    }

    private ContainerBoosterPack(int id, PlayerInventory playerInventory, double min, double max) {
        super(TYPE, id, playerInventory, 8, 60, TITLE, 3, ItemStack.field_190927_a);
        this.addSlotBox(0, 16, 16, this.cardSlots, 3, 1, 64, -1);
        if (min >= 0.0 && max > 0.0) {
            ItemStack stack1 = MCTCG.getRandomCard(min - 2.0, max - 1.0);
            this.cardSlots.insertItem(0, stack1, false);
            ItemStack stack2 = MCTCG.getRandomCard(min - 1.0, max);
            if (stack1.func_77973_b() != stack2.func_77973_b()) {
                this.cardSlots.insertItem(1, stack2, false);
            }
            ItemStack stack3 = MCTCG.getRandomCard(min, max);
            if (stack2.func_77973_b() != stack3.func_77973_b()) {
                this.cardSlots.insertItem(2, stack3, false);
            }
        }
    }

    public void func_75134_a(PlayerEntity player) {
        super.func_75134_a(player);
        this.keepIfValid(player, this.cardSlots.getStackInSlot(0));
        this.keepIfValid(player, this.cardSlots.getStackInSlot(1));
        this.keepIfValid(player, this.cardSlots.getStackInSlot(2));
    }

    public static SimpleNamedContainerProvider getServerContainerProvider(PlayerInventory playerInv, double min, double max) {
        return new SimpleNamedContainerProvider((id, playerInventory, serverPlayer) -> new ContainerBoosterPack(id, playerInv, min, max), TITLE);
    }

    class BoosterStackHandler
    extends ItemStackHandler {
        public BoosterStackHandler() {
            super(1);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == MCTCG.mctcg_coin;
        }
    }
}

