/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.container;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import wolforce.mctcg.container.tradingstation.ContainerTradingStation;
import wolforce.mctcg.util.Util;

public abstract class ContainerWithDefaultPlayerInventory
extends Container {
    protected ITextComponent title;
    protected IItemHandler playerInv;
    private int containerSize;

    protected ContainerWithDefaultPlayerInventory(ContainerType<?> type, int id, PlayerInventory playerInventory, int invX, int invY, ITextComponent title, int containerSize, ItemStack stack) {
        super(type, id);
        this.containerSize = containerSize;
        this.title = title;
        this.playerInv = new InvWrapper((IInventory)playerInventory);
        int disabledSlot = -1;
        if (Util.isValid(stack)) {
            for (int i = 0; i < this.playerInv.getSlots(); ++i) {
                if (playerInventory.func_70301_a(i) != stack) continue;
                disabledSlot = i;
            }
        }
        int index = this.addSlotBox(0, invX, invY + 58, this.playerInv, 9, 1, 18, -1, disabledSlot);
        this.addSlotBox(index, invX, invY, this.playerInv, 9, 3, 18, 18, disabledSlot);
    }

    public ITextComponent getName() {
        return this.title;
    }

    public int addSlotBox(int startIndex, int startX, int startY, IItemHandler handler, int width, int height, int dx, int dy) {
        return this.addSlotBox(startIndex, startX, startY, handler, width, height, dx, dy, -1);
    }

    public int addSlotBox(int startIndex, int startX, int startY, IItemHandler handler, int width, int height, int dx, int dy, int disabledStackIndex) {
        int index = startIndex;
        int x = startX;
        int y = startY;
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                if (index == disabledStackIndex) {
                    this.func_75146_a((Slot)new SlotDisabled(handler, index, x, y));
                } else {
                    this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
                }
                x += dx;
                ++index;
            }
            y += dy;
            x = startX;
        }
        return index;
    }

    protected void keepIfValid(PlayerEntity player, ItemStack stack) {
        if (!Util.isValid(stack)) {
            return;
        }
        if (!this.func_75135_a(stack, 0, 36, false)) {
            player.func_71019_a(stack, false);
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int sourceSlotIndex) {
        if (this instanceof ContainerTradingStation) {
            return ItemStack.field_190927_a;
        }
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        ItemStack copyOfSourceStack = sourceStack.func_77946_l();
        if (sourceSlotIndex >= 0 && sourceSlotIndex < 36) {
            if (!this.func_75135_a(sourceStack, 36, 36 + this.containerSize, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (sourceSlotIndex >= 36 && sourceSlotIndex < 36 + this.containerSize) {
            if (!this.func_75135_a(sourceStack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            return ItemStack.field_190927_a;
        }
        if (sourceStack.func_190916_E() == 0) {
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            sourceSlot.func_75218_e();
        }
        sourceSlot.func_190901_a(playerEntity, sourceStack);
        return copyOfSourceStack;
    }

    public static ITextComponent getName(ItemStack stack, ITextComponent defaultName) {
        return Util.isValid(stack) && stack.func_82837_s() ? stack.func_200301_q() : defaultName;
    }

    public class SlotDisabled
    extends SlotItemHandler {
        public SlotDisabled(IItemHandler handler, int i, int x, int y) {
            super(handler, i, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(PlayerEntity player) {
            return false;
        }
    }
}

