/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityCoin {
    @CapabilityInject(value=CapabilityCoin.class)
    public static final Capability<CapabilityCoin> CAPABILITY = null;
    private long time;
    private int coinsReceived;

    public CapabilityCoin() {
        this.reset();
    }

    public void reset() {
        this.time = System.currentTimeMillis();
    }

    public void set(long time) {
        this.time = System.currentTimeMillis() - time;
        this.willGetCoin(1.0);
    }

    public void increaseCoinsReceived(int i) {
        this.coinsReceived += i;
    }

    public double getChance() {
        long diff = System.currentTimeMillis() - this.time;
        double f = Math.max(0.003, Math.min(0.1, (double)(diff - 318000L) * 4.5E-14 * (double)(diff - 318000L)));
        if (this.coinsReceived > 10) {
            return f;
        }
        double g = Math.max(0.003, Math.min(0.1, (double)(diff - 31800L) * 4.5E-13 * (double)(diff - 31800L)));
        return f * (double)this.coinsReceived / 10.0 + g * (double)(1 - this.coinsReceived / 10);
    }

    public boolean willGetCoin(double probabilityMultiplier) {
        if (probabilityMultiplier == 0.0) {
            return Math.random() < this.getChance();
        }
        return Math.random() / probabilityMultiplier < this.getChance();
    }

    public void copyFrom(CapabilityCoin coinCap) {
        this.time = coinCap.time;
        this.coinsReceived = coinCap.coinsReceived;
    }

    public static CapabilityCoin get(PlayerEntity player) {
        CapabilityCoin exp = (CapabilityCoin)player.getCapability(CAPABILITY).orElse(null);
        if (exp == null) {
            throw new NullPointerException("Player Capability Missing!");
        }
        return exp;
    }

    public static class CoinCapStorage
    implements Capability.IStorage<CapabilityCoin> {
        @Nullable
        public INBT writeNBT(Capability<CapabilityCoin> capability, CapabilityCoin instance, Direction side) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a("time", instance.time);
            nbt.func_74768_a("coinsReceived", instance.coinsReceived);
            return nbt;
        }

        public void readNBT(Capability<CapabilityCoin> capability, CapabilityCoin instance, Direction side, INBT _nbt) {
            CompoundNBT nbt = (CompoundNBT)_nbt;
            instance.time = nbt.func_74763_f("time");
            instance.coinsReceived = nbt.func_74762_e("coinsReceived");
        }
    }

    public static class CoinCapProvider
    implements ICapabilitySerializable<INBT> {
        private LazyOptional<CapabilityCoin> instance = LazyOptional.of(() -> new CapabilityCoin());

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return CAPABILITY.getStorage().writeNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException()), null);
        }

        public void deserializeNBT(INBT nbt) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException()), null, nbt);
        }
    }
}

