/*
 * Decompiled with CFR 0.152.
 */
package wolforce.mctcg;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import wolforce.mctcg.blocks.TradingStationBlock;
import wolforce.mctcg.capabilities.CapabilityCoin;
import wolforce.mctcg.container.boosterpack.ContainerBoosterPack;
import wolforce.mctcg.container.cardbox.ContainerCardbox;
import wolforce.mctcg.container.deckbox.ContainerDeckbox;
import wolforce.mctcg.container.tradingstation.ContainerTradingStation;
import wolforce.mctcg.items.ItemBoosterPack;
import wolforce.mctcg.items.ItemCard;
import wolforce.mctcg.items.ItemDeckbox;
import wolforce.mctcg.util.Util;

@Mod(value="mctcg")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MCTCG {
    public static final String MODID = "mctcg";
    public static boolean dataGen = false;
    private static int[][] statsRpS = new int[ItemCard.EnumSource.values().length][];
    public static LinkedList<Block> blocks;
    public static LinkedList<Item> items;
    public static HashMap<ItemCard.EnumRarity, LinkedList<ItemCard>> cards;
    public static HashMap<String, ItemCard> cardsAll;
    public static Block trading_station;
    public static Item mctcg_coin;
    public static Item booster_pack;
    public static ItemCard rules_card;
    public static Item deckbox_black;
    public static Item deckbox_blue;
    public static Item deckbox_brown;
    public static Item deckbox_cyan;
    public static Item deckbox_green;
    public static Item deckbox_grey;
    public static Item deckbox_light_blue;
    public static Item deckbox_light_grey;
    public static Item deckbox_lime;
    public static Item deckbox_magenta;
    public static Item deckbox_orange;
    public static Item deckbox_pink;
    public static Item deckbox_purple;
    public static Item deckbox_red;
    public static Item deckbox_white;
    public static Item deckbox_yellow;
    public static Item cardbox_black;
    public static Item cardbox_blue;
    public static Item cardbox_brown;
    public static Item cardbox_cyan;
    public static Item cardbox_green;
    public static Item cardbox_grey;
    public static Item cardbox_light_blue;
    public static Item cardbox_light_grey;
    public static Item cardbox_lime;
    public static Item cardbox_magenta;
    public static Item cardbox_orange;
    public static Item cardbox_pink;
    public static Item cardbox_purple;
    public static Item cardbox_red;
    public static Item cardbox_white;
    public static Item cardbox_yellow;
    public static PointOfInterestType poi_trading_station;
    public static VillagerProfession profession_card_trader;
    public static ItemCard source_soil_1;
    public static ItemCard source_soil_2;
    public static ItemCard source_soil_3;
    public static ItemCard source_soil_4;
    public static ItemCard source_void_1;
    public static ItemCard source_void_2;
    public static ItemCard source_void_3;
    public static ItemCard source_void_4;
    public static ItemCard source_flora_1;
    public static ItemCard source_flora_2;
    public static ItemCard source_flora_3;
    public static ItemCard source_flora_4;
    public static ItemCard source_fauna_1;
    public static ItemCard source_fauna_2;
    public static ItemCard source_fauna_3;
    public static ItemCard source_fauna_4;
    public static ItemCard source_water_1;
    public static ItemCard source_water_2;
    public static ItemCard source_water_3;
    public static ItemCard source_water_4;
    public static ItemCard source_lava_1;
    public static ItemCard source_lava_2;
    public static ItemCard source_lava_3;
    public static ItemCard source_lava_4;
    public static ItemCard source_mind_1;
    public static ItemCard source_mind_2;
    public static ItemCard source_mind_3;
    public static ItemCard source_mind_4;
    public static ItemCard source_mob_1;
    public static ItemCard source_mob_2;
    public static ItemCard source_mob_3;
    public static ItemCard source_mob_4;
    public static ItemCard rune_of_the_dolphin;
    public static ItemCard fate_of_the_goat;
    public static ItemCard action_tree_lover;
    public static ItemCard rune_hoglin_onslaught;
    public static ItemCard source_strata;
    public static ItemCard source_destruction;
    public static ItemCard source_blue_planet;
    public static ItemCard source_pyromania;
    public static ItemCard source_green_lands;
    public static ItemCard source_infestation;
    public static ItemCard source_invention;
    public static ItemCard source_dark_intents;
    public static ItemCard rune_basalt_affinity;
    public static ItemCard rune_feline_grace;
    public static ItemCard rune_echolocation;
    public static ItemCard action_carrying_water;
    public static ItemCard action_gentle_glowstone;
    public static ItemCard fate_nether_spirit;
    public static ItemCard fate_nether_disciple;
    public static ItemCard fate_nether_flame;
    public static ItemCard rune_nether_wonder;
    public static ItemCard action_ender_ways;
    public static ItemCard rune_lunar_sight;
    public static ItemCard rune_devoted_training;
    public static ItemCard fate_aquatic_mammal;
    public static ItemCard fate_aura_of_the_wind;
    public static ItemCard rune_of_the_firesoul;
    public static ItemCard action_argil_pursuit;
    public static ItemCard rune_veteran_mountaineer;
    public static ItemCard action_diamond_prospector;
    public static ItemCard action_gold_prospector;
    public static ItemCard action_lapis_prospector;
    public static ItemCard action_redstone_prospector;
    public static ItemCard action_quartz_prospector;
    public static ItemCard action_grit_love;
    public static ItemCard action_vanishing_point;
    public static ItemCard rune_voidborn_pace;
    public static ItemCard rune_voidborn_might;
    public static ItemCard rune_voidborn_touch;
    public static ItemCard rune_fish_fins;
    public static ItemCard rune_deep_dweller;
    public static ItemCard action_snow_piles;
    public static ItemCard action_colourful_fins;
    public static ItemCard fate_nether_dweller;
    public static ItemCard fate_nether_juggernaut;
    public static ItemCard rune_wolves_sprint;
    public static ItemCard action_fowl_play;
    public static ItemCard fate_of_the_bear;
    public static ItemCard action_feather_feet;
    public static ItemCard rune_silverfish_speed;
    public static ItemCard action_calcium_mania;
    public static ItemCard action_creeping_rush;
    public static ItemCard action_earth_alchemy;
    public static ItemCard rune_aspect_of_iron;
    public static ItemCard rune_aspect_of_gold;
    public static ItemCard rune_aspect_of_lapis;
    public static ItemCard rune_aspect_of_redstone;
    public static ItemCard rune_aspect_of_diamond;

    public MCTCG() {
        if (!dataGen) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.initItems();
        try {
            int total;
            File file = new File("card_stats.txt");
            PrintWriter pw = new PrintWriter(file);
            pw.format("%-15s", "");
            for (ItemCard.EnumRarity enumRarity : ItemCard.EnumRarity.values()) {
                pw.format("%-15s", enumRarity == ItemCard.EnumRarity.Rules ? "Totals" : enumRarity.name());
            }
            pw.println();
            pw.println();
            for (Enum enum_ : ItemCard.EnumSource.values()) {
                pw.format("%-15s", new Object[]{ItemCard.EnumSource.values()[enum_.ordinal()]});
                total = 0;
                for (ItemCard.EnumRarity enumRarity : ItemCard.EnumRarity.values()) {
                    if (enumRarity == ItemCard.EnumRarity.Rules) {
                        pw.format("%-15s", total);
                        continue;
                    }
                    pw.format("%-15s", statsRpS[enum_.ordinal()][enumRarity.ordinal()]);
                    total += statsRpS[enum_.ordinal()][enumRarity.ordinal()];
                }
                pw.println();
                if ((enum_.ordinal() - 1) % 2 != 0) continue;
                pw.println("- - - - - - - - - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - - - - - - - - - - - - - - - -");
            }
            pw.println();
            pw.format("%-15s", "Totals");
            for (Enum enum_ : ItemCard.EnumRarity.values()) {
                total = 0;
                for (Enum enum_2 : ItemCard.EnumSource.values()) {
                    total += statsRpS[enum_2.ordinal()][enum_.ordinal()];
                }
                pw.format("%-15s", total);
            }
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void initItems() {
        ItemGroup group = new ItemGroup("MCTCG"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)source_flora_1);
            }
        };
        blocks = new LinkedList();
        items = new LinkedList();
        cardsAll = new HashMap();
        cards = new HashMap();
        for (ItemCard.EnumRarity rarity : ItemCard.EnumRarity.values()) {
            cards.put(rarity, new LinkedList());
        }
        Item.Properties itemProps = new Item.Properties().func_200916_a(group);
        mctcg_coin = this.regItem(new Item(itemProps.func_200917_a(64)), "mctcg_coin");
        booster_pack = this.regItem(new ItemBoosterPack(itemProps.func_200917_a(1)), "booster_pack");
        String rulesText = "Get coins by playing as usual. Craft a Trading Table and place coins in it to buy booster packs. You can get rarer cards the more coins you add. It is also a Villager job block. Place cards in a deck to gain powers. Cards require sources in the deck to be activated. The deck is ordered. Sources after a card do not count towards that card. Sources are not shared.";
        rules_card = new ItemCard(itemProps.func_200917_a(1), ItemCard.EnumCardType.Rules, "rules_card", "How to Play MCTCG", ItemCard.EnumRarity.Rules, ItemCard.EnumSource.Void, 0, false, rulesText, new ItemCard.EnumSource[0]);
        this.regItem(rules_card, "rules_card");
        deckbox_black = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_black");
        deckbox_blue = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_blue");
        deckbox_brown = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_brown");
        deckbox_cyan = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_cyan");
        deckbox_green = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_green");
        deckbox_grey = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_grey");
        deckbox_light_blue = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_light_blue");
        deckbox_light_grey = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_light_grey");
        deckbox_lime = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_lime");
        deckbox_magenta = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_magenta");
        deckbox_orange = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_orange");
        deckbox_pink = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_pink");
        deckbox_purple = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_purple");
        deckbox_red = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_red");
        deckbox_white = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_white");
        deckbox_yellow = this.regItem(new ItemDeckbox(itemProps, true), "deckbox_yellow");
        cardbox_black = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_black");
        cardbox_blue = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_blue");
        cardbox_brown = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_brown");
        cardbox_cyan = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_cyan");
        cardbox_green = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_green");
        cardbox_grey = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_grey");
        cardbox_light_blue = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_light_blue");
        cardbox_light_grey = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_light_grey");
        cardbox_lime = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_lime");
        cardbox_magenta = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_magenta");
        cardbox_orange = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_orange");
        cardbox_pink = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_pink");
        cardbox_purple = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_purple");
        cardbox_red = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_red");
        cardbox_white = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_white");
        cardbox_yellow = this.regItem(new ItemDeckbox(itemProps, false), "cardbox_yellow");
        ItemCard.properties = itemProps;
        this.initCommonCards();
        this.initUncommonCards();
        this.initRareCards();
        this.initEpicCards();
        itemProps.func_200917_a(64);
        AbstractBlock.Properties blockProps = AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.5f).func_200947_a(SoundType.field_185848_a);
        trading_station = this.regBlock(new TradingStationBlock(blockProps), "trading_station", itemProps);
    }

    private Block regBlock(Block block, String regName, Item.Properties itemProps) {
        BlockItem blockItem = new BlockItem(block, itemProps);
        block.setRegistryName(new ResourceLocation(MODID, regName));
        blockItem.setRegistryName(new ResourceLocation(MODID, regName));
        blocks.add(block);
        items.add((Item)blockItem);
        return block;
    }

    private ItemCard regCard(ItemCard card) {
        card = (ItemCard)this.regItem(card, card.regName);
        cardsAll.put(card.regName, card);
        cards.get((Object)card.field_208075_l).add(card);
        int[] nArray = statsRpS[card.source.ordinal()];
        int n = card.field_208075_l.ordinal();
        nArray[n] = nArray[n] + 1;
        return card;
    }

    private Item regItem(Item item, String regName) {
        items.add(item);
        item.setRegistryName(new ResourceLocation(MODID, regName));
        return item;
    }

    public void init(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(CapabilityCoin.class, (Capability.IStorage)new CapabilityCoin.CoinCapStorage(), CapabilityCoin::new);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> regEvent) {
        for (Item item : items) {
            regEvent.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> regEvent) {
        for (Block block : blocks) {
            regEvent.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerContainer(RegistryEvent.Register<ContainerType<?>> regEvent) {
        regEvent.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{(ContainerType)IForgeContainerType.create(ContainerDeckbox::new).setRegistryName("container_deckbox")});
        regEvent.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{(ContainerType)IForgeContainerType.create(ContainerCardbox::new).setRegistryName("container_cardbox")});
        regEvent.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{(ContainerType)IForgeContainerType.create(ContainerTradingStation::new).setRegistryName("container_trading_station")});
        regEvent.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{(ContainerType)IForgeContainerType.create(ContainerBoosterPack::new).setRegistryName("container_boosterpack")});
    }

    @SubscribeEvent
    public static void registerPointOfInterest(RegistryEvent.Register<PointOfInterestType> regEvent) {
        poi_trading_station = new PointOfInterestType("trading_station", Util.getAllStates(trading_station), 1, 1);
        poi_trading_station.setRegistryName(new ResourceLocation(MODID, "trading_station"));
        regEvent.getRegistry().register((IForgeRegistryEntry)poi_trading_station);
    }

    @SubscribeEvent
    public static void registerVillageStructure(RegistryEvent.Register<VillagerProfession> regEvent) {
        profession_card_trader = new VillagerProfession("card_trader", poi_trading_station, ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219702_mJ);
        profession_card_trader.setRegistryName(new ResourceLocation(MODID, "card_trader"));
        regEvent.getRegistry().register((IForgeRegistryEntry)profession_card_trader);
    }

    private void initCommonCards() {
        ItemCard.Card.nextRarity = ItemCard.EnumRarity.Common;
        ItemCard.EnumSource type = ItemCard.EnumSource.Soil;
        source_soil_1 = this.regCard(new ItemCard.CardSource("source_soil_1", "Soil", type));
        source_soil_2 = this.regCard(new ItemCard.CardSource("source_soil_2", "Ground", type));
        source_soil_3 = this.regCard(new ItemCard.CardSource("source_soil_3", "Rock", type));
        source_soil_4 = this.regCard(new ItemCard.CardSource("source_soil_4", "Earth", type));
        type = ItemCard.EnumSource.Void;
        source_void_1 = this.regCard(new ItemCard.CardSource("source_void_1", "Void", type));
        source_void_2 = this.regCard(new ItemCard.CardSource("source_void_2", "Hollow", type));
        source_void_3 = this.regCard(new ItemCard.CardSource("source_void_3", "Twilight", type));
        source_void_4 = this.regCard(new ItemCard.CardSource("source_void_4", "Darkness", type));
        type = ItemCard.EnumSource.Fauna;
        source_fauna_1 = this.regCard(new ItemCard.CardSource("source_fauna_1", "Fauna", type));
        source_fauna_2 = this.regCard(new ItemCard.CardSource("source_fauna_2", "Animalia", type));
        source_fauna_3 = this.regCard(new ItemCard.CardSource("source_fauna_3", "Wildlife", type));
        source_fauna_4 = this.regCard(new ItemCard.CardSource("source_fauna_4", "Beasts and Critters", type));
        type = ItemCard.EnumSource.Flora;
        source_flora_1 = this.regCard(new ItemCard.CardSource("source_flora_1", "Flora", type));
        source_flora_2 = this.regCard(new ItemCard.CardSource("source_flora_2", "Vegetation", type));
        source_flora_3 = this.regCard(new ItemCard.CardSource("source_flora_3", "Plant Life", type));
        source_flora_4 = this.regCard(new ItemCard.CardSource("source_flora_4", "Foliage", type));
        type = ItemCard.EnumSource.Water;
        source_water_1 = this.regCard(new ItemCard.CardSource("source_water_1", "Water", type));
        source_water_2 = this.regCard(new ItemCard.CardSource("source_water_2", "Torrents", type));
        source_water_3 = this.regCard(new ItemCard.CardSource("source_water_3", "Floods", type));
        source_water_4 = this.regCard(new ItemCard.CardSource("source_water_4", "Streams", type));
        type = ItemCard.EnumSource.Lava;
        source_lava_1 = this.regCard(new ItemCard.CardSource("source_lava_1", "Magma", type));
        source_lava_2 = this.regCard(new ItemCard.CardSource("source_lava_2", "Lava", type));
        source_lava_3 = this.regCard(new ItemCard.CardSource("source_lava_3", "Fire", type));
        source_lava_4 = this.regCard(new ItemCard.CardSource("source_lava_4", "Flames", type));
        type = ItemCard.EnumSource.Mind;
        source_mind_1 = this.regCard(new ItemCard.CardSource("source_mind_1", "Mind", type));
        source_mind_2 = this.regCard(new ItemCard.CardSource("source_mind_2", "Intelligence", type));
        source_mind_3 = this.regCard(new ItemCard.CardSource("source_mind_3", "Creation", type));
        source_mind_4 = this.regCard(new ItemCard.CardSource("source_mind_4", "Intellect", type));
        type = ItemCard.EnumSource.Mob;
        source_mob_1 = this.regCard(new ItemCard.CardSource("source_mob_1", "Monsters", type));
        source_mob_2 = this.regCard(new ItemCard.CardSource("source_mob_2", "Evil", type));
        source_mob_3 = this.regCard(new ItemCard.CardSource("source_mob_3", "Villainy", type));
        source_mob_4 = this.regCard(new ItemCard.CardSource("source_mob_4", "Corruption", type));
        action_argil_pursuit = this.regCard(new ItemCard.Card("action_argil_pursuit", "Argil Pursuit", ItemCard.EnumCardType.Action, "Breaking dirt near water sometimes drops a clay ball.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil));
        action_grit_love = this.regCard(new ItemCard.Card("action_grit_love", "Grit Love", ItemCard.EnumCardType.Action, "Never get flint from gravel.", ItemCard.EnumSource.Void, ItemCard.EnumSource.Soil));
        action_vanishing_point = this.regCard(new ItemCard.CardWithArtist("action_vanishing_point", "Vanishing Point", ItemCard.EnumCardType.Action, "When you break stone, there is a chance that it doesn't drop anything.", "Tsavorite", ItemCard.EnumSource.Void, ItemCard.EnumSource.Soil));
        rune_fish_fins = this.regCard(new ItemCard.Card("rune_fish_fins", "Fish Fins", ItemCard.EnumCardType.Rune, "Gain speed when moving in shallow waters.", ItemCard.EnumSource.Water, ItemCard.EnumSource.Fauna));
        rune_deep_dweller = this.regCard(new ItemCard.Card("deep_dweller", "Deep Dweller", ItemCard.EnumCardType.Rune, "Gain speed when moving in deep waters.", ItemCard.EnumSource.Water, ItemCard.EnumSource.Fauna));
        action_snow_piles = this.regCard(new ItemCard.CardWithArtist("action_snow_piles", "Snow Piles", ItemCard.EnumCardType.Action, "Create snow when throwing snowballs.", "MindFaer", ItemCard.EnumSource.Water, ItemCard.EnumSource.Soil));
        action_colourful_fins = this.regCard(new ItemCard.Card("action_colourful_fins", "Colourful Fins", ItemCard.EnumCardType.Action, "Tropical fish sometimes drop dyes.", ItemCard.EnumSource.Water, ItemCard.EnumSource.Fauna));
        fate_nether_dweller = this.regCard(new ItemCard.Card("fate_nether_dweller", "Nether Dweller", ItemCard.EnumCardType.Fate, "Gain a speed buff when you enter the nether.", ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Void));
        fate_nether_juggernaut = this.regCard(new ItemCard.Card("fate_nether_juggernaut", "Nether Juggernaut", ItemCard.EnumCardType.Fate, "Gain a strength buff when you enter the nether.", ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Soil));
        rune_wolves_sprint = this.regCard(new ItemCard.CardWithArtist("rune_wolves_sprint", "Wolves' Sprint", ItemCard.EnumCardType.Rune, "Gain speed when moving on snow.", "FrederikKnowsNothing", ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Mob));
        action_fowl_play = this.regCard(new ItemCard.Card("action_fowl_play", "Fowl Play", ItemCard.EnumCardType.Action, "Chance to get more chicken out of eggs.", ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Fauna));
        fate_of_the_bear = this.regCard(new ItemCard.Card("fate_of_the_bear", "Fate of the Bear", ItemCard.EnumCardType.Fate, "Chance to get strength when taking damage.", ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Mind));
        action_feather_feet = this.regCard(new ItemCard.Card("action_feather_feet", "Feather Feet", ItemCard.EnumCardType.Action, "You cannot trample farmed land.", ItemCard.EnumSource.Mind, ItemCard.EnumSource.Soil));
        rune_silverfish_speed = this.regCard(new ItemCard.Card("rune_silverfish_speed", "Silverfish Speed", ItemCard.EnumCardType.Rune, "Gain speed when moving on top of stone and cobblestone.", ItemCard.EnumSource.Mob, ItemCard.EnumSource.Soil));
        action_calcium_mania = this.regCard(new ItemCard.CardWithArtist("action_calcium_mania", "Calcium Mania", ItemCard.EnumCardType.Action, "Zombies and Spiders sometimes drop bones.", "Tsavorite", ItemCard.EnumSource.Fauna));
        action_creeping_rush = this.regCard(new ItemCard.Card("action_creeping_rush", "Creeping Rush", ItemCard.EnumCardType.Action, "Creepers sometimes drop sugar.", ItemCard.EnumSource.Mob, ItemCard.EnumSource.Flora));
    }

    private void initUncommonCards() {
        ItemCard.Card.nextRarity = ItemCard.EnumRarity.Uncommon;
        rune_veteran_mountaineer = this.regCard(new ItemCard.Card("rune_veteran_mountaineer", "Veteran Mountaineer", ItemCard.EnumCardType.Rune, "Gain haste in mountains.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Void));
        action_diamond_prospector = this.regCard(new ItemCard.Card("action_diamond_prospector", "Diamond Prospector", ItemCard.EnumCardType.Action, "When you mine coal ore, you have a small chance of finding diamond.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Lava));
        action_gold_prospector = this.regCard(new ItemCard.Card("action_gold_prospector", "Gold Prospector", ItemCard.EnumCardType.Action, "When you mine iron ore, you have a chance of finding gold nuggets.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Void));
        action_lapis_prospector = this.regCard(new ItemCard.Card("action_lapis_prospector", "Lapis Prospector", ItemCard.EnumCardType.Action, "When you mine lapis lazuli ore, you have a chance of getting more of it.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Water));
        action_redstone_prospector = this.regCard(new ItemCard.Card("action_redstone_prospector", "Redstone Prospector", ItemCard.EnumCardType.Action, "When you mine redstone ore, you have a chance of getting more of it.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Mind));
        action_quartz_prospector = this.regCard(new ItemCard.Card("action_quartz_prospector", "Quartz Prospector", ItemCard.EnumCardType.Action, "When you mine quartz ore, you have a chance of getting more of it.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Lava));
        rune_voidborn_pace = this.regCard(new ItemCard.Card("rune_voidborn_speed", "Voidborn Pace", ItemCard.EnumCardType.Rune, "Gain speed in the end.", ItemCard.EnumSource.Void, ItemCard.EnumSource.Mob, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Fauna));
        rune_voidborn_might = this.regCard(new ItemCard.Card("rune_voidborn_strength", "Voidborn Might", ItemCard.EnumCardType.Rune, "Gain strength in the end.", ItemCard.EnumSource.Void, ItemCard.EnumSource.Mob, ItemCard.EnumSource.Soil));
        rune_voidborn_touch = this.regCard(new ItemCard.Card("rune_voidborn_touch", "Voidborn Touch", ItemCard.EnumCardType.Rune, "Gain haste in the end.", ItemCard.EnumSource.Void, ItemCard.EnumSource.Mob, ItemCard.EnumSource.Water, ItemCard.EnumSource.Flora));
        fate_of_the_goat = this.regCard(new ItemCard.Card("fate_of_the_goat", "Fate of the Goat", ItemCard.EnumCardType.Fate, "Chance to get absorption when taking damage.", ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Mind));
        action_tree_lover = this.regCard(new ItemCard.Card("action_tree_lover", "Tree Lover", ItemCard.EnumCardType.Action, "Better chance of getting sapplings from trees.", ItemCard.EnumSource.Flora, ItemCard.EnumSource.Flora));
        fate_nether_spirit = this.regCard(new ItemCard.Card("fate_nether_spirit", "Nether Spirit", ItemCard.EnumCardType.Fate, "Gain a regeneration buff when you enter the nether.", ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Fauna));
        fate_nether_disciple = this.regCard(new ItemCard.Card("fate_nether_disciple", "Nether Disciple", ItemCard.EnumCardType.Fate, "Gain a luck buff when you enter the nether.", ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Void));
        fate_nether_flame = this.regCard(new ItemCard.Card("fate_nether_flame", "Nether Flame", ItemCard.EnumCardType.Fate, "Gain a fire resistance buff when you enter the nether.", ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Mind));
        action_earth_alchemy = this.regCard(new ItemCard.Card("action_earth_alchemy", "Earth Alchemy", ItemCard.EnumCardType.Action, "Chance to gain different kinds of rock when mining stone.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Mind, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Water));
        rune_hoglin_onslaught = this.regCard(new ItemCard.Card("rune_hoglin_onslaught", "Hoglin Onslaught", ItemCard.EnumCardType.Rune, "Gain speed when moving on top of netherrack.", ItemCard.EnumSource.Mob, ItemCard.EnumSource.Mob, ItemCard.EnumSource.Soil));
    }

    private void initRareCards() {
        ItemCard.Card.nextRarity = ItemCard.EnumRarity.Rare;
        source_strata = this.regCard(new ItemCard.CardRareSource("source_core", "Strata", ItemCard.EnumSource.Soil));
        source_destruction = this.regCard(new ItemCard.CardRareSourceWithArtist("source_destruction", "Destruction", "Andreway", ItemCard.EnumSource.Void));
        source_blue_planet = this.regCard(new ItemCard.CardRareSourceWithArtist("source_blue_planet", "Blue Planet", "Andreway", ItemCard.EnumSource.Water));
        source_pyromania = this.regCard(new ItemCard.CardRareSourceWithArtist("source_pyromania", "Pyromania", "Marbles", ItemCard.EnumSource.Lava));
        source_green_lands = this.regCard(new ItemCard.CardRareSource("source_green_lands", "Green Lands", ItemCard.EnumSource.Flora));
        source_infestation = this.regCard(new ItemCard.CardRareSourceWithArtist("source_infestation", "Infestation", "Jared Ng", ItemCard.EnumSource.Fauna));
        source_invention = this.regCard(new ItemCard.CardRareSource("source_invention", "Invention", ItemCard.EnumSource.Mind));
        source_dark_intents = this.regCard(new ItemCard.CardRareSource("source_dark_intents", "Dark Intents", ItemCard.EnumSource.Mob));
        rune_basalt_affinity = this.regCard(new ItemCard.Card("rune_basalt_affinity", "Basalt Afinity", ItemCard.EnumCardType.Rune, "Gain speed and haste in the basalt wastes.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil));
        rune_feline_grace = this.regCard(new ItemCard.Card("rune_feline_grace", "Feline Grace", ItemCard.EnumCardType.Rune, "Prevent some damage when falling from bigger heights.", ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Void, ItemCard.EnumSource.Void));
        rune_echolocation = this.regCard(new ItemCard.Card("rune_echolocation", "Rune of Echolocation", ItemCard.EnumCardType.Rune, "Get night vision when deep underground.", ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Void, ItemCard.EnumSource.Void));
        action_carrying_water = this.regCard(new ItemCard.Card("action_carrying_water", "Carrying Water", ItemCard.EnumCardType.Action, "Placing water from a bucket will not empty the bucket.", ItemCard.EnumSource.Water, ItemCard.EnumSource.Water, ItemCard.EnumSource.Mind));
        rune_of_the_dolphin = this.regCard(new ItemCard.CardWithArtist("rune_of_the_dolphin", "Rune of the Dolphin", ItemCard.EnumCardType.Rune, "Gain speed when swimming in oceans.", "Jared Ng", ItemCard.EnumSource.Water, ItemCard.EnumSource.Water, ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Fauna, ItemCard.EnumSource.Mind));
        action_gentle_glowstone = this.regCard(new ItemCard.Card("action_gentle_glowstone", "Gentle Glowstone", ItemCard.EnumCardType.Action, "When you mine glowstone, you have a better chance of getting 4 dust.", ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Mind));
        rune_nether_wonder = this.regCard(new ItemCard.Card("rune_nether_wonder", "Nether Wonder", ItemCard.EnumCardType.Rune, "You feel lucky when you're deeply surrounded by the nether.", ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Mind, ItemCard.EnumSource.Mob));
    }

    private void initEpicCards() {
        ItemCard.Card.nextRarity = ItemCard.EnumRarity.Epic;
        rune_lunar_sight = this.regCard(new ItemCard.Card("rune_lunar_sight", "Lunar Sight", ItemCard.EnumCardType.Rune, "Get night vision while under the moonlight.", ItemCard.EnumSource.Mind, ItemCard.EnumSource.Mind, ItemCard.EnumSource.Void));
        rune_devoted_training = this.regCard(new ItemCard.Card("rune_devoted_training", "Devoted Training", ItemCard.EnumCardType.Rune, "Somtimes gain Regeneration in the Overworld.", ItemCard.EnumSource.Mind, ItemCard.EnumSource.Mind, ItemCard.EnumSource.Mob, ItemCard.EnumSource.Mob));
        fate_aquatic_mammal = this.regCard(new ItemCard.Card("action_aquatic_mammal", "Aquatic Mammal", ItemCard.EnumCardType.Fate, "Lose hunger instead of health when suffocating.", ItemCard.EnumSource.Water, ItemCard.EnumSource.Water, ItemCard.EnumSource.Fauna));
        fate_aura_of_the_wind = this.regCard(new ItemCard.Card("fate_aura_of_the_wind", "Aura of the Wind", ItemCard.EnumCardType.Fate, "Chance to deflect projectiles.", ItemCard.EnumSource.Void, ItemCard.EnumSource.Void, ItemCard.EnumSource.Mind));
        action_ender_ways = this.regCard(new ItemCard.Card("action_ender_ways", "Ender Ways", ItemCard.EnumCardType.Action, "Get an Ender Pearl back when teleporting with it.", ItemCard.EnumSource.Void, ItemCard.EnumSource.Void, ItemCard.EnumSource.Void, ItemCard.EnumSource.Void));
        ItemCard.Card.nextRarity = ItemCard.EnumRarity.Legendary;
        rune_of_the_firesoul = this.regCard(new ItemCard.Card("rune_of_the_firesoul", "Rune of the Firesoul", ItemCard.EnumCardType.Rune, "Gain immunity to lava in the nether.", ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava));
        rune_aspect_of_iron = this.regCard(new ItemCard.Card("rune_aspect_of_iron", "Aspect of Iron", ItemCard.EnumCardType.Rune, "Stone around you may randomly turn into Iron Ore.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Mob, ItemCard.EnumSource.Mob, ItemCard.EnumSource.Mob));
        rune_aspect_of_gold = this.regCard(new ItemCard.Card("rune_aspect_of_gold", "Aspect of Gold", ItemCard.EnumCardType.Rune, "Stone around you may randomly turn into Gold Ore.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Mind, ItemCard.EnumSource.Mind, ItemCard.EnumSource.Mind));
        rune_aspect_of_lapis = this.regCard(new ItemCard.Card("rune_aspect_of_lapis", "Aspect of Lapis", ItemCard.EnumCardType.Rune, "Stone around you may randomly turn into Lapis Lazuli Ore.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Water, ItemCard.EnumSource.Water, ItemCard.EnumSource.Water));
        rune_aspect_of_redstone = this.regCard(new ItemCard.Card("rune_aspect_of_redstone", "Aspect of Redstone", ItemCard.EnumCardType.Rune, "Stone around you may randomly turn into Redstone Ore.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava, ItemCard.EnumSource.Lava));
        ItemCard.Card.nextRarity = ItemCard.EnumRarity.Mythic;
        rune_aspect_of_diamond = this.regCard(new ItemCard.Card("rune_aspect_of_diamond", "Aspect of Diamond", ItemCard.EnumCardType.Rune, "Stone around you may randomly turn into Diamond Ore.", ItemCard.EnumSource.Soil, ItemCard.EnumSource.Soil, ItemCard.EnumSource.Void, ItemCard.EnumSource.Void, ItemCard.EnumSource.Void));
    }

    public static ItemCard getCard(String regName) {
        return cardsAll.get(regName);
    }

    public static ItemStack getRandomCard(double min, double max) {
        Random random = new Random();
        if (random.nextDouble() < 0.05) {
            Object[] cardSet = cards.keySet().toArray();
            return new ItemStack((IItemProvider)MCTCG.getCard(cardSet[random.nextInt(cardSet.length)].toString()));
        }
        int finalRarityN = Math.min(ItemCard.EnumRarity.values().length, Math.max(0, (int)(min + random.nextDouble() * (max - min))));
        ItemCard.EnumRarity rarity = ItemCard.EnumRarity.values()[finalRarityN];
        LinkedList<ItemCard> cardsOfRarity = cards.get((Object)rarity);
        while (cardsOfRarity.isEmpty() && finalRarityN >= 0) {
            cardsOfRarity = cards.get((Object)ItemCard.EnumRarity.values()[--finalRarityN]);
        }
        ItemCard card = cardsOfRarity.get(random.nextInt(cardsOfRarity.size()));
        return new ItemStack((IItemProvider)card);
    }

    static {
        for (int i = 0; i < statsRpS.length; ++i) {
            MCTCG.statsRpS[i] = new int[ItemCard.EnumRarity.values().length];
        }
    }
}

