/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import com.google.common.collect.ImmutableList;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.AbstractDrawnInventoryEntity;
import de.mennomax.astikorcarts.inventory.container.PlowContainer;
import de.mennomax.astikorcarts.util.CartItemStackHandler;
import de.mennomax.astikorcarts.util.ProxyItemUseContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;

public final class PlowEntity
extends AbstractDrawnInventoryEntity {
    private static final int SLOT_COUNT = 3;
    private static final double BLADEOFFSET = 1.7;
    private static final DataParameter<Boolean> PLOWING = EntityDataManager.func_187226_a(PlowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final ImmutableList<DataParameter<ItemStack>> TOOLS = ImmutableList.of((Object)EntityDataManager.func_187226_a(PlowEntity.class, (IDataSerializer)DataSerializers.field_187196_f), (Object)EntityDataManager.func_187226_a(PlowEntity.class, (IDataSerializer)DataSerializers.field_187196_f), (Object)EntityDataManager.func_187226_a(PlowEntity.class, (IDataSerializer)DataSerializers.field_187196_f));

    public PlowEntity(EntityType<? extends Entity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.spacing = 2.0;
    }

    @Override
    protected AstikorCartsConfig.CartConfig getConfig() {
        return AstikorCartsConfig.COMMON.plow;
    }

    @Override
    protected ItemStackHandler initInventory() {
        return new CartItemStackHandler<PlowEntity>(3, this){

            protected void onLoad() {
                for (int i = 0; i < TOOLS.size(); ++i) {
                    ((PlowEntity)this.cart).func_184212_Q().func_187227_b((DataParameter)TOOLS.get(i), (Object)this.getStackInSlot(i));
                }
            }

            protected void onContentsChanged(int slot) {
                ((PlowEntity)this.cart).updateSlot(slot);
            }
        };
    }

    public boolean getPlowing() {
        return (Boolean)this.field_70180_af.func_187225_a(PLOWING);
    }

    @Override
    public void pulledTick() {
        super.pulledTick();
        if (this.getPulling() == null) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            PlayerEntity player = null;
            if (this.getPulling() instanceof PlayerEntity) {
                player = (PlayerEntity)this.getPulling();
            } else if (this.getPulling().func_184179_bs() instanceof PlayerEntity) {
                player = (PlayerEntity)this.getPulling().func_184179_bs();
            }
            if (((Boolean)this.field_70180_af.func_187225_a(PLOWING)).booleanValue() && player != null && (this.field_70169_q != this.func_226277_ct_() || this.field_70166_s != this.func_226281_cx_())) {
                this.plow(player);
            }
        }
    }

    private void plow(PlayerEntity player) {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (!(stack.func_77973_b() instanceof ToolItem)) continue;
            float offset = 38.0f - (float)i * 38.0f;
            double blockPosX = this.func_226277_ct_() + (double)MathHelper.func_76126_a((float)((float)Math.toRadians(this.field_70177_z - offset))) * 1.7;
            double blockPosZ = this.func_226281_cx_() - (double)MathHelper.func_76134_b((float)((float)Math.toRadians(this.field_70177_z - offset))) * 1.7;
            BlockPos blockPos = new BlockPos(blockPosX, this.func_226278_cu_() - 0.5, blockPosZ);
            boolean damageable = stack.func_77984_f();
            int count = stack.func_190916_E();
            stack.func_77973_b().func_195939_a((ItemUseContext)new ProxyItemUseContext(player, stack, new BlockRayTraceResult(Vector3d.field_186680_a, Direction.UP, blockPos, false)));
            if (!damageable || stack.func_190916_E() >= count) continue;
            this.func_184185_a(SoundEvents.field_187635_cQ, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            this.updateSlot(i);
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_226563_dT_()) {
            this.openContainer(player);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(PLOWING, (Object)((Boolean)this.field_70180_af.func_187225_a(PLOWING) == false ? 1 : 0));
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    public void updateSlot(int slot) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.inventory.getStackInSlot(slot).func_190926_b()) {
                this.field_70180_af.func_187227_b((DataParameter)TOOLS.get(slot), (Object)ItemStack.field_190927_a);
            } else {
                this.field_70180_af.func_187227_b((DataParameter)TOOLS.get(slot), (Object)this.inventory.getStackInSlot(slot));
            }
        }
    }

    public ItemStack getStackInSlot(int i) {
        return (ItemStack)this.field_70180_af.func_187225_a((DataParameter)TOOLS.get(i));
    }

    @Override
    public Item getCartItem() {
        return AstikorCarts.Items.PLOW.get();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLOWING, (Object)false);
        for (DataParameter param : TOOLS) {
            this.field_70180_af.func_187214_a(param, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(PLOWING, (Object)compound.func_74767_n("Plowing"));
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Plowing", ((Boolean)this.field_70180_af.func_187225_a(PLOWING)).booleanValue());
    }

    private void openContainer(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, p) -> new PlowContainer(windowId, playerInventory, (AbstractDrawnInventoryEntity)this), this.func_145748_c_()), buf -> buf.writeInt(this.func_145782_y()));
        }
    }
}

