/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.packets.SingleNoteClientPacket;
import xerca.xercamusic.common.packets.SingleNotePacket;

public class SingleNotePacketHandler {
    public static void handle(SingleNotePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when MusicUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> SingleNotePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(SingleNotePacket msg, ServerPlayerEntity pl) {
        PacketDistributor.PacketTarget target = PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(pl.func_226277_ct_(), pl.func_226278_cu_(), pl.func_226281_cx_(), 24.0, pl.func_71121_q().func_234923_W_()));
        SingleNoteClientPacket packet = new SingleNoteClientPacket(msg.getNote(), msg.getInstrumentItem(), (PlayerEntity)pl);
        XercaMusic.NETWORK_HANDLER.send(target, (Object)packet);
    }
}

