/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.packets.SingleNoteClientPacket;

public class SingleNoteClientPacketHandler {
    static Map<PlayerEntity, NoteSoundEntry> noteSounds = new HashMap<PlayerEntity, NoteSoundEntry>();

    public static void handle(SingleNoteClientPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> SingleNoteClientPacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(SingleNoteClientPacket msg) {
        PlayerEntity playerEntity = msg.getPlayerEntity();
        if (!playerEntity.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            SoundEvent sound = msg.getInstrumentItem().getSound(msg.getNote());
            double x = playerEntity.func_226277_ct_();
            double y = playerEntity.func_226278_cu_();
            double z = playerEntity.func_226281_cx_();
            NoteSound noteSound = XercaMusic.proxy.playNote(sound, x, y, z, SoundCategory.PLAYERS, 1.5f, 1.0f);
            if (msg.getInstrumentItem().shouldCutOff) {
                NoteSoundEntry oldNoteSoundEntry = noteSounds.get(playerEntity);
                if (oldNoteSoundEntry != null) {
                    oldNoteSoundEntry.noteSound.stopSound();
                }
                noteSounds.put(playerEntity, new NoteSoundEntry(noteSound, playerEntity));
            }
            playerEntity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, x + 0.5, y + 2.2, z + 0.5, (double)msg.getNote() / 24.0, 0.0, 0.0);
        }
    }

    private static class NoteSoundEntry {
        public NoteSound noteSound;
        public PlayerEntity playerEntity;

        public NoteSoundEntry(NoteSound noteSound, PlayerEntity playerEntity) {
            this.noteSound = noteSound;
            this.playerEntity = playerEntity;
        }
    }
}

