/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercamusic.common.Triggers;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.MusicUpdatePacket;

public class MusicUpdatePacketHandler {
    public static void handle(MusicUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when MusicUpdatePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> MusicUpdatePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(MusicUpdatePacket msg, ServerPlayerEntity pl) {
        ItemStack note = pl.func_184614_ca();
        if (!note.func_190926_b() && note.func_77973_b() == Items.MUSIC_SHEET) {
            CompoundNBT comp = note.func_196082_o();
            comp.func_74773_a("music", msg.getMusic());
            comp.func_74768_a("length", msg.getLength());
            comp.func_74774_a("pause", msg.getPause());
            comp.func_74768_a("generation", 0);
            comp.func_74774_a("prevIns", msg.getPrevInstrument());
            comp.func_74757_a("piLocked", msg.getPrevInsLocked());
            if (msg.getSigned()) {
                comp.func_74778_a("author", pl.func_200200_C_().getString());
                comp.func_74778_a("title", msg.getTitle().trim());
                comp.func_74768_a("generation", 1);
                Triggers.BECOME_MUSICIAN.trigger(pl);
            }
        }
    }
}

