/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.Arrays;
import net.minecraft.network.PacketBuffer;
import xerca.xercamusic.common.XercaMusic;

public class MusicUpdatePacket {
    private byte[] music;
    private int length;
    private byte pause;
    private boolean signed;
    private String title;
    private byte prevInstrument;
    private boolean prevInsLocked;
    private boolean messageIsValid;

    public MusicUpdatePacket(byte[] music, int length, byte pause, boolean signed, String title, byte prevInstrument, boolean prevInsLocked) {
        this.music = Arrays.copyOfRange(music, 0, length);
        this.length = length;
        this.pause = pause;
        this.signed = signed;
        this.title = title;
        this.prevInstrument = prevInstrument;
        this.prevInsLocked = prevInsLocked;
        XercaMusic.LOGGER.debug("MusicUpdatePacket length: " + length + " music length: " + this.music.length);
    }

    public MusicUpdatePacket() {
        this.messageIsValid = false;
    }

    public static MusicUpdatePacket decode(PacketBuffer buf) {
        MusicUpdatePacket result = new MusicUpdatePacket();
        try {
            result.title = buf.func_150789_c(255);
            result.signed = buf.readBoolean();
            result.pause = buf.readByte();
            result.length = buf.readInt();
            result.music = new byte[result.length];
            buf.readBytes(result.music, 0, result.length);
            result.prevInstrument = buf.readByte();
            result.prevInsLocked = buf.readBoolean();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading MusicUpdatePacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public static void encode(MusicUpdatePacket pkt, PacketBuffer buf) {
        buf.func_180714_a(pkt.title);
        buf.writeBoolean(pkt.signed);
        buf.writeByte((int)pkt.pause);
        buf.writeInt(pkt.length);
        buf.writeBytes(pkt.music);
        buf.writeByte((int)pkt.prevInstrument);
        buf.writeBoolean(pkt.prevInsLocked);
    }

    public byte[] getMusic() {
        return this.music;
    }

    public int getLength() {
        return this.length;
    }

    public byte getPause() {
        return this.pause;
    }

    public boolean getSigned() {
        return this.signed;
    }

    public String getTitle() {
        return this.title;
    }

    public byte getPrevInstrument() {
        return this.prevInstrument;
    }

    public boolean getPrevInsLocked() {
        return this.prevInsLocked;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }
}

