/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.MusicBoxUpdatePacket;
import xerca.xercamusic.common.tile_entity.TileEntityMusicBox;

public class MusicBoxUpdatePacketHandler {
    public static void handle(MusicBoxUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> MusicBoxUpdatePacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(MusicBoxUpdatePacket msg) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (!world.func_175667_e(msg.getPos())) {
            return;
        }
        TileEntity te = world.func_175625_s(msg.getPos());
        if (te instanceof TileEntityMusicBox) {
            TileEntityMusicBox tileEntityMusicBox = (TileEntityMusicBox)te;
            if (msg.getNoteStackNBT() != null) {
                if (msg.getNoteStackNBT().isEmpty()) {
                    tileEntityMusicBox.removeNoteStack();
                } else {
                    ItemStack noteStack = new ItemStack((IItemProvider)Items.MUSIC_SHEET);
                    noteStack.func_77982_d(msg.getNoteStackNBT());
                    tileEntityMusicBox.setNoteStack(noteStack);
                }
            }
            if (!msg.getInstrumentId().isEmpty()) {
                tileEntityMusicBox.setInstrument((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(msg.getInstrumentId())));
            } else {
                tileEntityMusicBox.removeInstrument();
            }
        }
    }
}

