/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.packets;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xerca.xercamusic.common.XercaMusic;

public class MusicBoxUpdatePacket {
    private BlockPos pos;
    private CompoundNBT noteStackNBT;
    private String instrumentId;
    private boolean messageIsValid;

    public MusicBoxUpdatePacket(BlockPos pos, ItemStack noteStack, Item itemInstrument) {
        ResourceLocation resourcelocation;
        this.pos = pos;
        this.noteStackNBT = noteStack == null ? null : (noteStack.func_77942_o() ? noteStack.func_77978_p() : new CompoundNBT());
        this.instrumentId = itemInstrument != null ? ((resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)itemInstrument)) == null ? "minecraft:air" : resourcelocation.toString()) : "";
    }

    public MusicBoxUpdatePacket() {
        this.messageIsValid = false;
    }

    public static MusicBoxUpdatePacket decode(PacketBuffer buf) {
        MusicBoxUpdatePacket result = new MusicBoxUpdatePacket();
        try {
            result.pos = buf.func_179259_c();
            result.noteStackNBT = buf.func_150793_b();
            result.instrumentId = buf.func_150789_c(255);
        }
        catch (IndexOutOfBoundsException ioe) {
            XercaMusic.LOGGER.error("Exception while reading MusicBoxUpdatePacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public static void encode(MusicBoxUpdatePacket pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.func_150786_a(pkt.noteStackNBT);
        buf.func_180714_a(pkt.instrumentId);
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public CompoundNBT getNoteStackNBT() {
        return this.noteStackNBT;
    }

    public void setNoteStackNBT(CompoundNBT noteStackNBT) {
        this.noteStackNBT = noteStackNBT;
    }

    public String getInstrumentId() {
        return this.instrumentId;
    }

    public void setInstrumentId(String instrumentId) {
        this.instrumentId = instrumentId;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }
}

