/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.entity.EntityMusicSpirit;
import xerca.xercamusic.common.item.Items;

public class ItemInstrument
extends Item {
    private SoundEvent[] sounds;
    public boolean shouldCutOff;
    private final int instrumentId;

    ItemInstrument(String name, boolean shouldCutOff, int instrumentId) {
        super(new Item.Properties().func_200916_a((ItemGroup)Items.musicTab));
        this.setRegistryName(name);
        this.shouldCutOff = shouldCutOff;
        this.instrumentId = instrumentId;
    }

    public int getInstrumentId() {
        return this.instrumentId;
    }

    public SoundEvent getSound(int i) {
        return this.sounds[i];
    }

    public void playMusic(World worldIn, PlayerEntity playerIn, boolean canStop) {
        List musicSpirits = worldIn.func_175647_a(EntityMusicSpirit.class, playerIn.func_174813_aQ().func_186662_g(3.0), entity -> entity.getBody().func_70028_i((Entity)playerIn));
        if (musicSpirits.size() == 0) {
            worldIn.func_217376_c((Entity)new EntityMusicSpirit(worldIn, playerIn, (ItemInstrument)playerIn.func_184614_ca().func_77973_b()));
        } else if (canStop) {
            musicSpirits.forEach(spirit -> spirit.setPlaying(false));
        }
    }

    public void setSounds(SoundEvent[] sounds) {
        this.sounds = sounds;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        ItemStack off = playerIn.func_184592_cb();
        if (handIn == Hand.MAIN_HAND && off.func_77973_b() == Items.MUSIC_SHEET) {
            if (!worldIn.field_72995_K) {
                this.playMusic(worldIn, playerIn, true);
            }
        } else {
            XercaMusic.proxy.showInstrumentGui();
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState iblockstate = world.func_180495_p(blockpos = context.func_195995_a());
        if (iblockstate.func_177230_c() == Blocks.MUSIC_BOX && !((Boolean)iblockstate.func_177229_b((Property)BlockMusicBox.HAS_INSTRUMENT)).booleanValue()) {
            ItemStack itemstack = context.func_195996_i();
            if (!world.field_72995_K) {
                BlockMusicBox.insertInstrument((IWorld)world, blockpos, iblockstate, itemstack.func_77973_b());
                if (context.func_195999_j() != null && !context.func_195999_j().field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        World world = attacker.field_70170_p;
        if (!world.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                world.func_184133_a(null, target.func_233580_cy_(), this.sounds[world.field_73012_v.nextInt(48)], SoundCategory.PLAYERS, 3.0f, 1.0f);
            }
        }
        return true;
    }
}

