/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockInstrument;
import xerca.xercamusic.common.entity.Entities;
import xerca.xercamusic.common.item.ItemInstrument;
import xerca.xercamusic.common.item.Items;

public class EntityMusicSpirit
extends Entity
implements IEntityAdditionalSpawnData {
    private PlayerEntity body;
    private ItemStack note;
    private ItemInstrument instrument;
    private byte[] music;
    private int mLength;
    private int mTime;
    private byte mPause;
    private NoteSound lastPlayed = null;
    private boolean isPlaying = true;
    private BlockInstrument blockInstrument = null;
    private BlockPos blockInsPos = null;

    public EntityMusicSpirit(World worldIn) {
        super(Entities.MUSIC_SPIRIT, worldIn);
    }

    public EntityMusicSpirit(World worldIn, PlayerEntity body, ItemInstrument instrument) {
        super(Entities.MUSIC_SPIRIT, worldIn);
        this.body = body;
        this.instrument = instrument;
        this.setNoteFromBody();
        this.mTime = 0;
        this.func_70107_b(body.func_226277_ct_(), body.func_226278_cu_(), body.func_226281_cx_());
        if (this.note.func_77942_o() && this.note.func_77978_p().func_74764_b("music")) {
            CompoundNBT comp = this.note.func_77978_p();
            this.music = comp.func_74770_j("music");
            this.mLength = comp.func_74762_e("length");
            this.mPause = comp.func_74771_c("pause");
        }
    }

    public EntityMusicSpirit(World worldIn, PlayerEntity body, BlockPos blockInsPos, ItemInstrument instrument) {
        this(worldIn, body, instrument);
        this.setBlockPosAndInstrument(blockInsPos);
    }

    public EntityMusicSpirit(EntityType<EntityMusicSpirit> type, World world) {
        super(type, world);
    }

    public EntityMusicSpirit(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(world);
    }

    private void setBlockPosAndInstrument(BlockPos pos) {
        this.blockInsPos = pos;
        Block block = this.field_70170_p.func_180495_p(this.blockInsPos).func_177230_c();
        if (block instanceof BlockInstrument) {
            this.blockInstrument = (BlockInstrument)block;
            this.func_70107_b((double)this.blockInsPos.func_177958_n() + 0.5, (double)this.blockInsPos.func_177956_o() - 0.5, (double)this.blockInsPos.func_177952_p() + 0.5);
        } else {
            XercaMusic.LOGGER.warn("Got invalid block as instrument");
            this.blockInstrument = null;
            this.blockInsPos = null;
        }
    }

    private boolean isBodyHandLegit() {
        ItemStack mainStack = this.body.func_184614_ca();
        ItemStack offStack = this.body.func_184592_cb();
        if (this.blockInstrument != null && this.blockInsPos != null) {
            return mainStack.func_77973_b() == Items.MUSIC_SHEET || offStack.func_77973_b() == Items.MUSIC_SHEET;
        }
        return offStack.func_77973_b() == Items.MUSIC_SHEET && mainStack.func_77973_b() == this.instrument;
    }

    private void setNoteFromBody() {
        ItemStack mainStack = this.body.func_184614_ca();
        ItemStack offStack = this.body.func_184592_cb();
        if (mainStack.func_77973_b() == Items.MUSIC_SHEET) {
            this.note = mainStack;
        } else if (offStack.func_77973_b() == Items.MUSIC_SHEET) {
            this.note = offStack;
        } else {
            XercaMusic.LOGGER.warn("No music sheet found on body");
        }
    }

    protected void func_70037_a(CompoundNBT tagCompound) {
        this.music = tagCompound.func_74770_j("music");
        this.mLength = tagCompound.func_74762_e("length");
        this.mPause = tagCompound.func_74771_c("pause");
        this.isPlaying = tagCompound.func_74767_n("playing");
        if (tagCompound.func_74764_b("bX") && tagCompound.func_74764_b("bY") && tagCompound.func_74764_b("bZ")) {
            this.setBlockPosAndInstrument(new BlockPos(tagCompound.func_74762_e("bX"), tagCompound.func_74762_e("bY"), tagCompound.func_74762_e("bZ")));
        }
    }

    protected void func_213281_b(CompoundNBT tagCompound) {
        tagCompound.func_74773_a("music", this.music);
        tagCompound.func_74768_a("length", this.mLength);
        tagCompound.func_74774_a("pause", this.mPause);
        tagCompound.func_74757_a("playing", this.isPlaying);
        if (this.blockInstrument != null && this.blockInsPos != null) {
            tagCompound.func_74768_a("bX", this.blockInsPos.func_177958_n());
            tagCompound.func_74768_a("bY", this.blockInsPos.func_177956_o());
            tagCompound.func_74768_a("bZ", this.blockInsPos.func_177952_p());
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.body != null ? this.body.func_145782_y() : -1);
        if (this.blockInstrument != null && this.blockInsPos != null) {
            buffer.writeInt(this.blockInsPos.func_177958_n());
            buffer.writeInt(this.blockInsPos.func_177956_o());
            buffer.writeInt(this.blockInsPos.func_177952_p());
        } else {
            buffer.writeInt(-1);
            buffer.writeInt(-1);
            buffer.writeInt(-1);
        }
    }

    public void readSpawnData(PacketBuffer buffer) {
        int id = buffer.readInt();
        Entity ent = this.field_70170_p.func_73045_a(id);
        if (ent instanceof PlayerEntity) {
            this.body = (PlayerEntity)ent;
        }
        int bx = buffer.readInt();
        int by = buffer.readInt();
        int bz = buffer.readInt();
        if (by >= 0) {
            this.setBlockPosAndInstrument(new BlockPos(bx, by, bz));
        }
        this.mTime = 0;
        if (this.blockInsPos != null) {
            this.instrument = this.blockInstrument.getItemInstrument();
            this.setNoteFromBody();
        } else {
            this.instrument = (ItemInstrument)this.body.func_184614_ca().func_77973_b();
            this.note = this.body.func_184592_cb();
            this.func_70107_b(this.body.func_226277_ct_(), this.body.func_226278_cu_(), this.body.func_226281_cx_());
        }
        if (this.note.func_77942_o() && this.note.func_77978_p().func_74764_b("music")) {
            CompoundNBT comp = this.note.func_77978_p();
            this.music = comp.func_74770_j("music");
            this.mLength = comp.func_74762_e("length");
            this.mPause = comp.func_74771_c("pause");
        }
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.body == null || !this.isPlaying) {
                this.func_70106_y();
                return;
            }
            if (!this.isBodyHandLegit()) {
                this.isPlaying = false;
                this.func_70106_y();
                return;
            }
            if (this.blockInsPos != null && this.blockInstrument != null) {
                if (this.field_70170_p.func_180495_p(this.blockInsPos).func_177230_c() != this.blockInstrument) {
                    this.func_70106_y();
                    return;
                }
                if (this.func_213303_ch().func_72438_d(this.body.func_213303_ch()) > 4.0) {
                    this.func_70106_y();
                    return;
                }
            }
        }
        super.func_70071_h_();
        if ((this.blockInsPos == null || this.blockInstrument == null) && this.body != null) {
            this.func_70107_b(this.body.func_226277_ct_(), this.body.func_226278_cu_(), this.body.func_226281_cx_());
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.mPause == 0) {
                System.err.println("EntityMusicSpirit mPause is 0! THIS SHOULD NOT HAPPEN!");
                return;
            }
            if (this.field_70173_aa % this.mPause == 0) {
                if (this.mTime == this.mLength) {
                    XercaMusic.proxy.endMusic(this.func_145782_y(), this.body.func_145782_y());
                    this.func_70106_y();
                    return;
                }
                if (this.music[this.mTime] != 0 && this.music[this.mTime] <= 48) {
                    if (this.instrument.shouldCutOff && this.lastPlayed != null) {
                        this.lastPlayed.stopSound();
                    }
                    this.lastPlayed = XercaMusic.proxy.playNote(this.instrument.getSound(this.music[this.mTime] - 1), this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_());
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, this.func_226277_ct_(), this.func_226278_cu_() + 2.2, this.func_226281_cx_(), (double)(this.music[this.mTime] - 1) / 24.0, 0.0, 0.0);
                }
                ++this.mTime;
            }
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public PlayerEntity getBody() {
        return this.body;
    }

    public void setBody(PlayerEntity body) {
        this.body = body;
    }
}

