/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.item.ItemInstrument;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.tile_entity.TileEntityMusicBox;

public class BlockMusicBox
extends HorizontalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty POWERING = BooleanProperty.func_177716_a((String)"powering");
    public static final BooleanProperty HAS_MUSIC = BooleanProperty.func_177716_a((String)"has_music");
    public static final BooleanProperty HAS_INSTRUMENT = BooleanProperty.func_177716_a((String)"has_instrument");

    public BlockMusicBox() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_MUSIC, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_INSTRUMENT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERING, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("music_box");
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())))).func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f());
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn != null && !worldIn.field_72995_K) {
            boolean powered = worldIn.func_175640_z(pos);
            if (powered && ((Boolean)state.func_177229_b((Property)POWERING)).booleanValue()) {
                return;
            }
            if (powered != (Boolean)state.func_177229_b((Property)POWERED)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
            }
        }
    }

    private void ejectItem(World world, BlockPos pos, BlockState state, boolean isMusic, boolean isBreaking) {
        TileEntity tileentity;
        if (!world.field_72995_K && (tileentity = world.func_175625_s(pos)) instanceof TileEntityMusicBox) {
            ItemStack itemstack;
            TileEntityMusicBox te = (TileEntityMusicBox)tileentity;
            ItemStack itemStack = itemstack = isMusic ? te.getNoteStack().func_77946_l() : new ItemStack((IItemProvider)te.getInstrument());
            if (!itemstack.func_190926_b()) {
                ItemEntity entityitem;
                if (!isBreaking) {
                    if (isMusic) {
                        te.removeNoteStack();
                        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HAS_MUSIC, (Comparable)Boolean.FALSE), 3);
                    } else {
                        te.removeInstrument();
                        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HAS_INSTRUMENT, (Comparable)Boolean.FALSE), 3);
                    }
                }
                if (isMusic) {
                    entityitem = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p(), itemstack);
                    entityitem.func_213293_j(world.field_73012_v.nextDouble() * 0.2 - 0.1, 0.1, world.field_73012_v.nextDouble() * 0.2 - 0.1);
                } else {
                    Direction backFace = ((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d();
                    int xOffset = backFace.func_82601_c();
                    int zOffset = backFace.func_82599_e();
                    entityitem = new ItemEntity(world, (double)pos.func_177958_n() + (double)xOffset * 0.625, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + (double)zOffset * 0.625, itemstack);
                    double speed = world.field_73012_v.nextDouble() * 0.1 + 0.2;
                    entityitem.func_213293_j((double)xOffset * speed, 0.1, (double)zOffset * speed);
                }
                entityitem.func_174869_p();
                world.func_217376_c((Entity)entityitem);
            }
        }
    }

    public static void insertMusic(IWorld worldIn, BlockPos pos, BlockState state, ItemStack noteStack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityMusicBox) {
            ((TileEntityMusicBox)tileentity).setNoteStack(noteStack);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HAS_MUSIC, (Comparable)Boolean.TRUE), 3);
        }
    }

    public static void insertInstrument(IWorld worldIn, BlockPos pos, BlockState state, Item instrument) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityMusicBox) {
            ((TileEntityMusicBox)tileentity).setInstrument(instrument);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)HAS_INSTRUMENT, (Comparable)Boolean.TRUE), 3);
        }
        worldIn.func_217378_a(null, 1012, pos, 0);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (hit.func_216354_b() == Direction.UP && ((Boolean)state.func_177229_b((Property)HAS_MUSIC)).booleanValue()) {
            if (heldItem.func_77973_b() instanceof ItemInstrument && !((Boolean)state.func_177229_b((Property)HAS_INSTRUMENT)).booleanValue()) {
                return ActionResultType.PASS;
            }
            this.ejectItem(worldIn, pos, state, true, false);
            return ActionResultType.SUCCESS;
        }
        if (hit.func_216354_b() == ((Direction)state.func_177229_b((Property)field_185512_D)).func_176734_d() && ((Boolean)state.func_177229_b((Property)HAS_INSTRUMENT)).booleanValue()) {
            if (heldItem.func_77973_b() == Items.MUSIC_SHEET && !((Boolean)state.func_177229_b((Property)HAS_MUSIC)).booleanValue()) {
                return ActionResultType.PASS;
            }
            worldIn.func_217378_a(null, 1006, pos, 0);
            this.ejectItem(worldIn, pos, state, false, false);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != Blocks.MUSIC_BOX || newState.func_177230_c() != Blocks.MUSIC_BOX) {
            this.ejectItem(worldIn, pos, state, true, true);
            this.ejectItem(worldIn, pos, state, false, true);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED, HAS_MUSIC, HAS_INSTRUMENT, field_185512_D, POWERING});
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileEntityMusicBox();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.func_177229_b((Property)POWERING)).booleanValue()) {
            return 0;
        }
        return ((Direction)blockState.func_177229_b((Property)field_185512_D)).func_176735_f() == side ? 15 : 0;
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }
}

