/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.engine;

import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineTileEntity;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.teammoeg.steampowered.FluidRegistry;
import com.teammoeg.steampowered.content.engine.SteamEngineBlock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class SteamEngineTileEntity
extends EngineTileEntity
implements IHaveGoggleInformation {
    private FluidTank tank;
    private LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private int heatup = 0;

    public SteamEngineTileEntity(TileEntityType<? extends SteamEngineTileEntity> type) {
        super(type);
        this.refreshCapability();
        this.tank = new FluidTank(this.getSteamStorage(), fluidStack -> {
            ITag steamTag = FluidTags.func_226157_a_().func_199910_a(new ResourceLocation("forge", "steam"));
            if (steamTag != null) {
                return fluidStack.getFluid().func_207185_a(steamTag);
            }
            return fluidStack.getFluid() == FluidRegistry.steam.get();
        });
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (this.poweredWheel == null || this.poweredWheel.func_145837_r()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(false)));
                this.refreshWheelSpeed();
                this.heatup = 0;
                this.tank.drain(this.getSteamConsumptionPerTick(), IFluidHandler.FluidAction.EXECUTE);
            } else if (!this.tank.isEmpty() && this.tank.drain(this.getSteamConsumptionPerTick(), IFluidHandler.FluidAction.EXECUTE).getAmount() >= this.getSteamConsumptionPerTick()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(true)));
                if (this.heatup >= 60) {
                    this.appliedCapacity = this.getGeneratingCapacity();
                    this.appliedSpeed = this.getGeneratingSpeed();
                    this.refreshWheelSpeed();
                } else {
                    ++this.heatup;
                }
            } else {
                if (this.heatup > 0) {
                    --this.heatup;
                }
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(false)));
                this.appliedCapacity = 0.0f;
                this.appliedSpeed = 0.0f;
                this.refreshWheelSpeed();
            }
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            this.func_70296_d();
        }
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        if (!((Boolean)this.func_195044_w().func_177229_b((Property)SteamEngineBlock.LIT)).booleanValue()) {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.steampowered.steam_engine.not_enough_steam").func_240699_a_(TextFormatting.RED)));
        } else if (this.heatup < 60) {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.steampowered.steam_engine.heating").func_240699_a_(TextFormatting.YELLOW)));
        } else {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.steampowered.steam_engine.running").func_240699_a_(TextFormatting.GREEN)));
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }

    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.tank.readFromNBT(compound.func_74775_l("TankContent"));
        this.heatup = compound.func_74762_e("heatup");
    }

    public void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_218657_a("TankContent", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        compound.func_74768_a("heatup", this.heatup);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.holder.isPresent()) {
            this.refreshCapability();
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.holder.cast() : super.getCapability(capability, facing);
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.holder;
        this.holder = LazyOptional.of(() -> this.tank);
        oldCap.invalidate();
    }

    public void attachWheel() {
        TileEntity te;
        Direction wheelFacing;
        Direction engineFacing = (Direction)this.func_195044_w().func_177229_b((Property)EngineBlock.field_185512_D);
        BlockPos wheelPos = this.field_174879_c.func_177967_a(engineFacing, 2);
        BlockState wheelState = this.field_145850_b.func_180495_p(wheelPos);
        if (!(this.getFlywheel() != wheelState.func_177230_c() || (wheelFacing = (Direction)wheelState.func_177229_b(FlywheelBlock.HORIZONTAL_FACING)).func_176740_k() != engineFacing.func_176746_e().func_176740_k() || FlywheelBlock.isConnected((BlockState)wheelState) && FlywheelBlock.getConnection((BlockState)wheelState) != engineFacing.func_176734_d() || (te = this.field_145850_b.func_175625_s(wheelPos)).func_145837_r() || !(te instanceof FlywheelTileEntity))) {
            if (!FlywheelBlock.isConnected((BlockState)wheelState)) {
                FlywheelBlock.setConnection((World)this.field_145850_b, (BlockPos)te.func_174877_v(), (BlockState)te.func_195044_w(), (Direction)engineFacing.func_176734_d());
            }
            this.poweredWheel = (FlywheelTileEntity)te;
            this.refreshWheelSpeed();
        }
    }

    public abstract Block getFlywheel();

    public abstract float getGeneratingCapacity();

    public abstract float getGeneratingSpeed();

    public abstract int getSteamConsumptionPerTick();

    public abstract int getSteamStorage();
}

