/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.engine;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.teammoeg.steampowered.FluidRegistry;
import com.teammoeg.steampowered.ItemRegistry;
import com.teammoeg.steampowered.client.Particles;
import com.teammoeg.steampowered.content.engine.SteamEngineTileEntity;
import com.teammoeg.steampowered.registrate.SPTiles;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SteamEngineBlock
extends EngineBlock {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;

    public SteamEngineBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196000_l();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)(facing.func_176740_k().func_200128_b() ? context.func_195992_f().func_176734_d() : facing))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new Property[]{LIT}));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return SPTiles.BRONZE_STEAM_ENGINE.create();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.FURNACE_ENGINE.get((Direction)state.func_177229_b((Property)field_185512_D));
    }

    @Nullable
    public PartialModel getFrameModel() {
        return AllBlockPartials.FURNACE_GENERATOR_FRAME;
    }

    protected boolean isValidBaseBlock(BlockState baseBlock, IBlockReader world, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        if (((Boolean)p_180655_1_.func_177229_b((Property)LIT)).booleanValue()) {
            double d0 = (double)p_180655_3_.func_177958_n() + 0.5;
            double d1 = p_180655_3_.func_177956_o();
            double d2 = (double)p_180655_3_.func_177952_p() + 0.5;
            if (p_180655_4_.nextDouble() < 0.1) {
                p_180655_2_.func_184134_a(d0, d1, d2, SoundEvents.field_219619_am, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)p_180655_1_.func_177229_b((Property)field_185512_D);
            Direction.Axis direction$axis = direction.func_176740_k();
            double d3 = 0.52;
            double d4 = p_180655_4_.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : d4;
            double d6 = p_180655_4_.nextDouble() * 9.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : d4;
            p_180655_2_.func_195594_a((IParticleData)Particles.STEAM.get(), d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (player.func_184586_b(hand).func_77973_b() == ItemRegistry.pressurizedSteamContainer.get()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof SteamEngineTileEntity) {
                SteamEngineTileEntity steamEngine = (SteamEngineTileEntity)te;
                IFluidHandler cap = (IFluidHandler)steamEngine.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).resolve().get();
                cap.fill(new FluidStack((Fluid)FluidRegistry.steam.get(), 1000), IFluidHandler.FluidAction.EXECUTE);
                player.func_184586_b(hand).func_190918_g(1);
                ItemStack ret = new ItemStack((IItemProvider)ItemRegistry.pressurizedGasContainer.get());
                if (!player.func_191521_c(ret)) {
                    world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ret));
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, blockRayTraceResult);
    }
}

