/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.burner;

import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.teammoeg.steampowered.client.ClientUtils;
import com.teammoeg.steampowered.content.alternator.DynamoTileEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BurnerBlock
extends Block {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty REDSTONE_LOCKED = BooleanProperty.func_177716_a((String)"redstone_locked");

    public BurnerBlock(AbstractBlock.Properties props) {
        super(props.func_235838_a_(s -> (Boolean)s.func_177229_b((Property)LIT) != false ? 10 : 0));
    }

    public void func_180655_c(BlockState bs, World w, BlockPos bp, Random r) {
        super.func_180655_c(bs, w, bp, r);
        if (((Boolean)bs.func_177229_b((Property)LIT)).booleanValue()) {
            double d0 = (double)bp.func_177958_n() + 0.5;
            double d1 = bp.func_177956_o();
            double d2 = (double)bp.func_177952_p() + 0.5;
            if (r.nextDouble() < 0.2) {
                w.func_184134_a(d0, d1, d2, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            if (r.nextDouble() < 0.5) {
                Direction direction = (Direction)bs.func_177229_b((Property)FACING);
                Direction.Axis direction$axis = direction.func_176740_k();
                double d4 = w.func_201674_k().nextDouble() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * 0.52 : d4;
                double d6 = w.func_201674_k().nextDouble() * 6.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * 0.52 : d4;
                w.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                w.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196000_l();
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)(facing.func_176740_k().func_200128_b() ? context.func_195992_f().func_176734_d() : facing))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)REDSTONE_LOCKED, (Comparable)Boolean.valueOf(false));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_176199_a(World w, BlockPos p, Entity e) {
        if (((Boolean)w.func_180495_p(p).func_177229_b((Property)LIT)).booleanValue() && e instanceof LivingEntity) {
            e.func_70097_a(DamageSource.field_190095_e, 2.0f);
        }
    }

    public abstract int getHuProduce();

    public abstract double getEfficiency();

    public String getEfficiencyString() {
        return (float)((int)(this.getEfficiency() * 1000.0)) / 10.0f + "%";
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new Property[]{LIT}).func_206894_a(new Property[]{FACING}).func_206894_a(new Property[]{REDSTONE_LOCKED}));
    }

    public void func_190948_a(ItemStack i, IBlockReader w, List<ITextComponent> t, ITooltipFlag f) {
        if (Screen.func_231173_s_()) {
            t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.burner.brief").func_240699_a_(TextFormatting.GOLD));
            if (ClientUtils.hasGoggles()) {
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.burner.efficiency", new Object[]{this.getEfficiencyString()}).func_240699_a_(TextFormatting.RED));
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.burner.huproduce", new Object[]{this.getHuProduce()}).func_240699_a_(TextFormatting.GOLD));
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.burner.danger").func_240699_a_(TextFormatting.RED));
            }
        } else {
            t.add((ITextComponent)TooltipHelper.holdShift((ItemDescription.Palette)ItemDescription.Palette.Gray, (boolean)false));
        }
        if (Screen.func_231172_r_()) {
            t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.burner.redstone").func_240699_a_(TextFormatting.RED));
        } else {
            t.add((ITextComponent)Lang.translate((String)"tooltip.holdForControls", (Object[])new Object[]{Lang.translate((String)"tooltip.keyCtrl", (Object[])new Object[0]).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        super.func_190948_a(i, w, t, f);
    }

    public ActionResultType func_225533_a_(BlockState bs, World w, BlockPos bp, PlayerEntity pe, Hand h, BlockRayTraceResult br) {
        if (pe.func_184586_b(h).func_190926_b()) {
            IItemHandler cap = (IItemHandler)w.func_175625_s(bp).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get();
            ItemStack is = cap.getStackInSlot(0);
            if (!is.func_190926_b()) {
                pe.func_184611_a(h, cap.extractItem(0, is.func_190916_E(), false));
                return ActionResultType.SUCCESS;
            }
        } else if (ForgeHooks.getBurnTime((ItemStack)pe.func_184586_b(h)) != 0 && pe.func_184586_b(h).getContainerItem().func_190926_b()) {
            IItemHandler cap = (IItemHandler)w.func_175625_s(bp).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get();
            pe.func_184611_a(h, cap.insertItem(0, pe.func_184586_b(h), false));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!world.field_72995_K) {
            boolean isLocked;
            TileEntity tileentity;
            TileEntity tileEntity = tileentity = state.hasTileEntity() ? world.func_175625_s(pos) : null;
            if (tileentity != null && tileentity instanceof DynamoTileEntity) {
                ((DynamoTileEntity)tileentity).updateCache();
            }
            if ((isLocked = ((Boolean)state.func_177229_b((Property)REDSTONE_LOCKED)).booleanValue()) != world.func_175640_z(pos)) {
                if (isLocked) {
                    world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
                } else {
                    world.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)REDSTONE_LOCKED), 2);
                }
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld serverworld, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)REDSTONE_LOCKED)).booleanValue() && !serverworld.func_175640_z(pos)) {
            serverworld.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)REDSTONE_LOCKED), 2);
        }
    }
}

