/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.boiler;

import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.teammoeg.steampowered.client.ClientUtils;
import com.teammoeg.steampowered.client.Particles;
import com.teammoeg.steampowered.content.boiler.BoilerTileEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class BoilerBlock
extends Block
implements ILiquidContainer {
    public boolean func_204510_a(IBlockReader w, BlockPos p, BlockState s, Fluid f) {
        TileEntity te = w.func_175625_s(p);
        if (te instanceof BoilerTileEntity) {
            BoilerTileEntity boiler = (BoilerTileEntity)te;
            if (boiler.input.fill(new FluidStack(f, 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                return true;
            }
        }
        return false;
    }

    public boolean func_204509_a(IWorld w, BlockPos p, BlockState s, FluidState f) {
        TileEntity te = w.func_175625_s(p);
        if (te instanceof BoilerTileEntity) {
            BoilerTileEntity boiler = (BoilerTileEntity)te;
            if (boiler.input.fill(new FluidStack(f.func_206886_c(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                boiler.input.fill(new FluidStack(f.func_206886_c(), 1000), IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return false;
    }

    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        TileEntity te = p_180655_2_.func_175625_s(p_180655_3_);
        if (te instanceof BoilerTileEntity) {
            BoilerTileEntity boiler = (BoilerTileEntity)te;
            if (boiler.output.getFluidAmount() >= 10000 && boiler.lastheat != 0) {
                double d0 = p_180655_3_.func_177958_n();
                double d1 = p_180655_3_.func_177956_o() + 1;
                double d2 = p_180655_3_.func_177952_p();
                p_180655_2_.func_184134_a(d0, d1, d2, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.25f, 0.25f, false);
                int count = 4;
                while (--count != 0) {
                    p_180655_2_.func_195594_a((IParticleData)Particles.STEAM.get(), d0 + (double)p_180655_4_.nextFloat(), d1, d2 + (double)p_180655_4_.nextFloat(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public BoilerBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public int func_180641_l(BlockState b, World w, BlockPos p) {
        TileEntity te = w.func_175625_s(p);
        if (te instanceof BoilerTileEntity) {
            BoilerTileEntity boiler = (BoilerTileEntity)te;
            return boiler.output.getFluidAmount() * 15 / boiler.output.getCapacity();
        }
        return super.func_180641_l(b, w, p);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public abstract int getHuConsume();

    public void func_190948_a(ItemStack i, IBlockReader w, List<ITextComponent> t, ITooltipFlag f) {
        if (Screen.func_231173_s_()) {
            t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.brief").func_240699_a_(TextFormatting.GOLD));
            if (ClientUtils.hasGoggles()) {
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.danger").func_240699_a_(TextFormatting.RED));
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.huconsume", new Object[]{this.getHuConsume()}).func_240699_a_(TextFormatting.GOLD));
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.waterconsume", new Object[]{(int)Math.ceil((double)this.getHuConsume() / 120.0)}).func_240699_a_(TextFormatting.AQUA));
                t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.steamproduce", new Object[]{this.getHuConsume() / 10}).func_240699_a_(TextFormatting.GOLD));
            }
        } else {
            t.add((ITextComponent)TooltipHelper.holdShift((ItemDescription.Palette)ItemDescription.Palette.Gray, (boolean)false));
        }
        if (Screen.func_231172_r_()) {
            t.add((ITextComponent)new TranslationTextComponent("tooltip.steampowered.boiler.redstone").func_240699_a_(TextFormatting.RED));
        } else {
            t.add((ITextComponent)Lang.translate((String)"tooltip.holdForControls", (Object[])new Object[]{Lang.translate((String)"tooltip.keyCtrl", (Object[])new Object[0]).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        super.func_190948_a(i, w, t, f);
    }

    public void func_176199_a(World w, BlockPos bp, Entity e) {
        TileEntity te = w.func_175625_s(bp);
        if (te instanceof BoilerTileEntity && e instanceof LivingEntity && (((BoilerTileEntity)te).lastheat > 0 || !((BoilerTileEntity)te).output.isEmpty())) {
            e.func_70097_a(DamageSource.field_190095_e, 2.0f);
        }
    }
}

