/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered;

import net.minecraftforge.common.ForgeConfigSpec;

public class SPConfig {
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final Common COMMON;
    public static final Server SERVER;

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
        COMMON = new Common(COMMON_BUILDER);
        SERVER = new Server(SERVER_BUILDER);
        SERVER_CONFIG = SERVER_BUILDER.build();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }

    public static class Server {
        Server(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue bronzeFlywheelCapacity;
        public final ForgeConfigSpec.IntValue bronzeFlywheelSpeed;
        public final ForgeConfigSpec.IntValue bronzeFlywheelSteamConsumptionPerTick;
        public final ForgeConfigSpec.IntValue bronzeFlywheelSteamStorage;
        public final ForgeConfigSpec.IntValue castIronFlywheelCapacity;
        public final ForgeConfigSpec.IntValue castIronFlywheelSpeed;
        public final ForgeConfigSpec.IntValue castIronFlywheelSteamConsumptionPerTick;
        public final ForgeConfigSpec.IntValue castIronFlywheelSteamStorage;
        public final ForgeConfigSpec.IntValue steelFlywheelCapacity;
        public final ForgeConfigSpec.IntValue steelFlywheelSpeed;
        public final ForgeConfigSpec.IntValue steelFlywheelSteamConsumptionPerTick;
        public final ForgeConfigSpec.IntValue steelFlywheelSteamStorage;
        public final ForgeConfigSpec.IntValue HUPerFuelTick;
        public final ForgeConfigSpec.DoubleValue steamPerWater;
        public final ForgeConfigSpec.IntValue bronzeBoilerHU;
        public final ForgeConfigSpec.IntValue castIronBoilerHU;
        public final ForgeConfigSpec.IntValue steelBoilerHU;
        public final ForgeConfigSpec.IntValue bronzeBurnerHU;
        public final ForgeConfigSpec.IntValue castIronBurnerHU;
        public final ForgeConfigSpec.IntValue steelBurnerHU;
        public final ForgeConfigSpec.DoubleValue bronzeBurnerEfficiency;
        public final ForgeConfigSpec.DoubleValue castIronBurnerEfficiency;
        public final ForgeConfigSpec.DoubleValue steelBurnerEfficiency;
        public final ForgeConfigSpec.IntValue dynamoFeMaxOut;
        public final ForgeConfigSpec.IntValue dynamoFeCapacity;
        public final ForgeConfigSpec.IntValue dynamoImpact;
        public final ForgeConfigSpec.DoubleValue dynamoEfficiency;
        public final ForgeConfigSpec.DoubleValue bronzeCogwheelImpact;
        public final ForgeConfigSpec.DoubleValue castIronCogwheelImpact;
        public final ForgeConfigSpec.DoubleValue steelCogwheelImpact;

        Common(ForgeConfigSpec.Builder builder) {
            builder.push("steam");
            this.HUPerFuelTick = builder.comment("HU generation for each fuel burning tick. 10HU=1mb of steam. THIS AFFECT ALL BURNERS AND BOILERS!").defineInRange("HuPerFuelTick", 24, 0, 655360);
            this.steamPerWater = builder.comment("This defines how many mbs of steam does a mb of water can turn into.").defineInRange("steamPerWater", 12.0, 0.0, 100000.0);
            builder.pop();
            builder.push("boiler").comment("Maximum HU the boiler intakes. 10HU=1mb of steam. ");
            this.bronzeBoilerHU = builder.defineInRange("bronzeBoilerHu", 120, 0, 1000000);
            this.castIronBoilerHU = builder.defineInRange("castIronBoilerHu", 240, 0, 1000000);
            this.steelBoilerHU = builder.defineInRange("steelBoilerHu", 480, 0, 1000000);
            builder.pop();
            builder.push("burner").comment("Maximum HU the boiler emits. Note that this does not affect steam per fuel tick. 10HU=1mb of steam. ");
            this.bronzeBurnerHU = builder.defineInRange("bronzeBurnerHu", 120, 0, 1000000);
            this.castIronBurnerHU = builder.defineInRange("castIronBurnerHu", 240, 0, 1000000);
            this.steelBurnerHU = builder.defineInRange("steelBurnerHu", 480, 0, 1000000);
            builder.pop();
            builder.push("burnerEfficiency").comment("Fuel Tick to HU Convertion Percentage. 10HU=1mb of steam. ");
            this.bronzeBurnerEfficiency = builder.defineInRange("bronzeBurnerEfficiency", 0.8, 0.0, 1.0);
            this.castIronBurnerEfficiency = builder.defineInRange("castIronBurnerEfficiency", 0.9, 0.0, 1.0);
            this.steelBurnerEfficiency = builder.defineInRange("steelBurnerEfficiency", 1.0, 0.0, 1.0);
            builder.pop();
            builder.push("flywheel");
            builder.push("bronze_flywheel");
            this.bronzeFlywheelCapacity = builder.defineInRange("bronzeFlywheelCapacity", 512, 0, 8192);
            this.bronzeFlywheelSpeed = builder.defineInRange("bronzeFlywheelSpeed", 32, 0, 8192);
            this.bronzeFlywheelSteamConsumptionPerTick = builder.defineInRange("bronzeFlywheelSteamConsumptionPerTick", 12, 0, 8192);
            this.bronzeFlywheelSteamStorage = builder.defineInRange("bronzeFlywheelSteamStorage", 32000, 0, 0x100000);
            builder.pop();
            builder.push("cast_iron_flywheel");
            this.castIronFlywheelCapacity = builder.defineInRange("castIronFlywheelCapacity", 1024, 0, 8192);
            this.castIronFlywheelSpeed = builder.defineInRange("castIronFlywheelSpeed", 32, 0, 8192);
            this.castIronFlywheelSteamConsumptionPerTick = builder.defineInRange("castIronFlywheelSteamConsumptionPerTick", 24, 0, 8192);
            this.castIronFlywheelSteamStorage = builder.defineInRange("castIronFlywheelSteamStorage", 64000, 0, 0x100000);
            builder.pop();
            builder.push("steel_flywheel");
            this.steelFlywheelCapacity = builder.defineInRange("steelFlywheelCapacity", 2048, 0, 8192);
            this.steelFlywheelSpeed = builder.defineInRange("steelFlywheelSpeed", 32, 0, 8192);
            this.steelFlywheelSteamConsumptionPerTick = builder.defineInRange("steelFlywheelSteamConsumptionPerTick", 48, 0, 0x100000);
            this.steelFlywheelSteamStorage = builder.defineInRange("steelFlywheelSteamStorage", 96000, 0, 0x100000);
            builder.pop();
            builder.pop();
            builder.push("dynamo").comment("If dynamo is disabled in the server config, the following will be ignored!");
            this.dynamoFeMaxOut = builder.defineInRange("dynamoFeMaxOut", 256, 0, 8192);
            this.dynamoFeCapacity = builder.defineInRange("dynamoFeCapacity", 2048, 0, 8192);
            this.dynamoImpact = builder.defineInRange("dynamoImpact", 16, 0, 8192);
            this.dynamoEfficiency = builder.defineInRange("dynamoEfficiency", 0.75, 0.0, 1.0);
            builder.pop();
            builder.push("cogwheel").comment("For those who want to make the game more challenging, you can add stress impact to cogwheels!");
            this.bronzeCogwheelImpact = builder.defineInRange("bronzeCogwheelImpact", 0.0, 0.0, 1.0);
            this.castIronCogwheelImpact = builder.defineInRange("castIronCogwheelImpact", 0.0, 0.0, 1.0);
            this.steelCogwheelImpact = builder.defineInRange("steelCogwheelImpact", 0.0, 0.0, 1.0);
            builder.pop();
        }
    }
}

