/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileGroup;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileGroupsS2CPacket
extends S2CPacket {
    public static final int TILE_GROUPS_PER_PACKET = 100;
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "tile", "groups");
    int atlasID;
    RegistryKey<World> world;
    List<TileGroup> tileGroups;

    public TileGroupsS2CPacket(int atlasID, RegistryKey<World> world, List<TileGroup> tileGroups) {
        this.atlasID = atlasID;
        this.world = world;
        this.tileGroups = tileGroups;
    }

    public static void encode(TileGroupsS2CPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(msg.atlasID);
        packetBuffer.func_192572_a(msg.world.func_240901_a_());
        packetBuffer.func_150787_b(msg.tileGroups.size());
        for (TileGroup tileGroup : msg.tileGroups) {
            packetBuffer.func_150786_a(tileGroup.writeToNBT(new CompoundNBT()));
        }
    }

    public static TileGroupsS2CPacket decode(PacketBuffer packetBuffer) {
        int atlasID = packetBuffer.func_150792_a();
        RegistryKey world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)packetBuffer.func_192575_l());
        int length = packetBuffer.func_150792_a();
        ArrayList<TileGroup> tileGroups = new ArrayList<TileGroup>(length);
        for (int i = 0; i < length; ++i) {
            CompoundNBT tag = packetBuffer.func_150793_b();
            if (tag == null) continue;
            tileGroups.add(new TileGroup().readFromNBT(tag));
        }
        return new TileGroupsS2CPacket(atlasID, (RegistryKey<World>)world, tileGroups);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean handle(ClientPlayerEntity player) {
        AtlasData atlasData = AntiqueAtlasMod.tileData.getData(this.atlasID, player.field_70170_p);
        WorldData dimData = atlasData.getWorldData(this.world);
        for (TileGroup t : this.tileGroups) {
            dimData.putTileGroup(t);
        }
        return true;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

