/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileInfo;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DimensionUpdateS2CPacket
extends S2CPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "dimension", "update");
    int atlasID;
    RegistryKey<World> world;
    Collection<TileInfo> tiles;

    public DimensionUpdateS2CPacket(int atlasID, RegistryKey<World> world, Collection<TileInfo> tiles) {
        this.atlasID = atlasID;
        this.world = world;
        this.tiles = tiles;
    }

    public static void encode(DimensionUpdateS2CPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(msg.atlasID);
        packetBuffer.func_192572_a(msg.world.func_240901_a_());
        packetBuffer.func_150787_b(msg.tiles.size());
        for (TileInfo tile : msg.tiles) {
            packetBuffer.func_150787_b(tile.x);
            packetBuffer.func_150787_b(tile.z);
            packetBuffer.func_192572_a(tile.id);
        }
    }

    public static DimensionUpdateS2CPacket decode(PacketBuffer packetBuffer) {
        int atlasID = packetBuffer.func_150792_a();
        RegistryKey world = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)packetBuffer.func_192575_l());
        int tileCount = packetBuffer.func_150792_a();
        ArrayList<TileInfo> tiles = new ArrayList<TileInfo>();
        for (int i = 0; i < tileCount; ++i) {
            tiles.add(new TileInfo(packetBuffer.func_150792_a(), packetBuffer.func_150792_a(), packetBuffer.func_192575_l()));
        }
        return new DimensionUpdateS2CPacket(atlasID, (RegistryKey<World>)world, tiles);
    }

    @Override
    public boolean shouldRun() {
        return this.world != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean handle(ClientPlayerEntity player) {
        AtlasData data = AntiqueAtlasMod.tileData.getData(this.atlasID, player.field_70170_p);
        for (TileInfo info : this.tiles) {
            data.getWorldData(this.world).setTile(info.x, info.z, info.id);
        }
        return true;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

