/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.network.packet.c2s.C2SPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PutTileC2SPacket
extends C2SPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "c2s", "tile", "put");
    int atlasID;
    int x;
    int z;
    ResourceLocation tile;

    public PutTileC2SPacket(int atlasID, int x, int z, ResourceLocation tile) {
        this.atlasID = atlasID;
        this.x = x;
        this.z = z;
        this.tile = tile;
    }

    public static void encode(PutTileC2SPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.atlasID);
        packetBuffer.func_150787_b(msg.x);
        packetBuffer.func_150787_b(msg.z);
        packetBuffer.func_192572_a(msg.tile);
    }

    public static PutTileC2SPacket decode(PacketBuffer packetBuffer) {
        return new PutTileC2SPacket(packetBuffer.func_150792_a(), packetBuffer.func_150792_a(), packetBuffer.func_150792_a(), packetBuffer.func_192575_l());
    }

    public static void handle(PutTileC2SPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (((Boolean)AntiqueAtlasConfig.itemNeeded.get()).booleanValue() && !AtlasAPI.getPlayerAtlases((PlayerEntity)context.getSender()).contains(msg.atlasID)) {
                Log.warn("Player %s attempted to modify someone else's Atlas #%d", context.getSender().func_200200_C_(), msg.atlasID);
                return;
            }
            AtlasAPI.getTileAPI().putTile(sender.func_130014_f_(), msg.atlasID, msg.tile, msg.x, msg.z);
        });
        context.setPacketHandled(true);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

