/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.network.packet.c2s.C2SPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class DeleteMarkerRequestC2SPacket
extends C2SPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "c2s", "marker", "delete");
    private static final int GLOBAL = -1;
    int atlasID;
    int markerID;

    public DeleteMarkerRequestC2SPacket(int atlasID, int markerID) {
        this.atlasID = atlasID;
        this.markerID = markerID;
    }

    public static void encode(DeleteMarkerRequestC2SPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(msg.atlasID);
        packetBuffer.func_150787_b(msg.markerID);
    }

    public static DeleteMarkerRequestC2SPacket decode(PacketBuffer packetBuffer) {
        return new DeleteMarkerRequestC2SPacket(packetBuffer.func_150792_a(), packetBuffer.func_150792_a());
    }

    public static void handle(DeleteMarkerRequestC2SPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity sender = context.getSender();
            if (sender == null) {
                return;
            }
            if (((Boolean)AntiqueAtlasConfig.itemNeeded.get()).booleanValue() && !AtlasAPI.getPlayerAtlases((PlayerEntity)context.getSender()).contains(msg.atlasID)) {
                Log.warn("Player %s attempted to delete marker from someone else's Atlas #%d", context.getSender().func_200200_C_(), msg.atlasID);
                return;
            }
            AtlasAPI.getMarkerAPI().deleteMarker(context.getSender().func_130014_f_(), msg.atlasID, msg.markerID);
        });
        context.setPacketHandled(true);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

