/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.c2s.play;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.network.packet.c2s.C2SPacket;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.network.NetworkEvent;

public class AddMarkerC2SPacket
extends C2SPacket {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "c2s", "marker", "add");
    int atlasID;
    ResourceLocation markerType;
    int x;
    int z;
    boolean visibleBeforeDiscovery;
    ITextComponent label;

    public AddMarkerC2SPacket(int atlasID, ResourceLocation markerType, int x, int z, boolean visibleBeforeDiscovery, ITextComponent label) {
        this.atlasID = atlasID;
        this.markerType = markerType;
        this.x = x;
        this.z = z;
        this.visibleBeforeDiscovery = visibleBeforeDiscovery;
        this.label = label;
    }

    public static void encode(AddMarkerC2SPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.func_150787_b(msg.atlasID);
        packetBuffer.func_192572_a(msg.markerType);
        packetBuffer.func_150787_b(msg.x);
        packetBuffer.func_150787_b(msg.z);
        packetBuffer.writeBoolean(msg.visibleBeforeDiscovery);
        packetBuffer.func_179256_a(msg.label);
    }

    public static AddMarkerC2SPacket decode(PacketBuffer packetBuffer) {
        return new AddMarkerC2SPacket(packetBuffer.func_150792_a(), packetBuffer.func_192575_l(), packetBuffer.func_150792_a(), packetBuffer.func_150792_a(), packetBuffer.readBoolean(), packetBuffer.func_179258_d());
    }

    public static void handle(AddMarkerC2SPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity sender = context.getSender();
            if (sender == null) {
                return;
            }
            ServerPlayerEntity player = context.getSender();
            if (!AtlasAPI.getPlayerAtlases((PlayerEntity)player).contains(msg.atlasID)) {
                AntiqueAtlasMod.LOG.warn("Player {} attempted to put marker into someone else's Atlas #{}}", (Object)player.func_200200_C_(), (Object)msg.atlasID);
                return;
            }
            AtlasAPI.getMarkerAPI().putMarker(player.field_70170_p, msg.visibleBeforeDiscovery, msg.atlasID, msg.markerType, msg.label, msg.x, msg.z);
        });
        context.setPacketHandled(true);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

