/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.item;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeAtlasCombining
implements ICraftingRecipe {
    public static final IRecipeSerializer<RecipeAtlasCombining> SERIALIZER = new SpecialRecipeSerializer(RecipeAtlasCombining::new);
    private final ResourceLocation id;

    public RecipeAtlasCombining(ResourceLocation id) {
        this.id = id;
    }

    public String func_193358_e() {
        return "antiqueatlas:atlas_combine";
    }

    public boolean matches(CraftingInventory inv, World world) {
        return this.matches(inv);
    }

    private boolean matches(CraftingInventory inv) {
        int atlasesFound = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != RegistrarAntiqueAtlas.ATLAS) continue;
            ++atlasesFound;
        }
        return atlasesFound > 1;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack firstAtlas = ItemStack.field_190927_a;
        ArrayList<Integer> atlasIds = new ArrayList<Integer>(9);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof AtlasItem)) continue;
            if (firstAtlas.func_190926_b()) {
                firstAtlas = stack;
                continue;
            }
            atlasIds.add(AtlasItem.getAtlasID(stack));
        }
        return atlasIds.size() < 1 ? ItemStack.field_190927_a : firstAtlas.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)RegistrarAntiqueAtlas.ATLAS);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return IRecipeType.field_222149_a;
    }

    public ItemStack onCrafted(World world, IInventory iInventory, ItemStack result) {
        if (world.field_72995_K) {
            return result;
        }
        int atlasID = AntiqueAtlasMod.getGlobalAtlasData(world).getNextAtlasId();
        AtlasData destBiomes = AntiqueAtlasMod.tileData.getData(atlasID, world);
        destBiomes.func_76185_a();
        MarkersData destMarkers = AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
        destMarkers.func_76185_a();
        for (int i = 0; i < iInventory.func_70302_i_(); ++i) {
            ItemStack stack = iInventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            AtlasData srcBiomes = AntiqueAtlasMod.tileData.getData(stack, world);
            if (destBiomes != null && srcBiomes != null && destBiomes != srcBiomes) {
                for (RegistryKey<World> worldRegistryKey : srcBiomes.getVisitedWorlds()) {
                    destBiomes.getWorldData(worldRegistryKey).addData(srcBiomes.getWorldData(worldRegistryKey));
                }
            }
            MarkersData srcMarkers = AntiqueAtlasMod.markersData.getMarkersData(stack, world);
            if (destMarkers == null || srcMarkers == null || destMarkers == srcMarkers) continue;
            for (RegistryKey<World> worldRegistryKey : srcMarkers.getVisitedDimensions()) {
                for (Marker marker : srcMarkers.getMarkersDataInWorld(worldRegistryKey).getAllMarkers()) {
                    destMarkers.createAndSaveMarker(marker.getType(), worldRegistryKey, marker.getX(), marker.getZ(), marker.isVisibleAhead(), marker.getLabel());
                }
            }
        }
        result.func_196082_o().func_74768_a("atlasID", atlasID);
        return result;
    }
}

