/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.forge.hook;

import hunternif.mc.impl.atlas.forge.event.ItemCraftedEvent;
import hunternif.mc.impl.atlas.forge.event.MarkerHoveredEvent;
import hunternif.mc.impl.atlas.forge.event.StructureAddedEvent;
import hunternif.mc.impl.atlas.forge.event.StructurePieceAddedEvent;
import hunternif.mc.impl.atlas.forge.event.TileIdRegisteredEvent;
import hunternif.mc.impl.atlas.marker.Marker;
import java.util.Collection;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AntiqueAtlasHooks {
    public static void fireTileIdRegistered(Collection<ResourceLocation> tileIds) {
        MinecraftForge.EVENT_BUS.post((Event)new TileIdRegisteredEvent(tileIds));
    }

    public static void fireStructureAdded(StructureStart<?> structureStart, ServerWorld world) {
        MinecraftForge.EVENT_BUS.post((Event)new StructureAddedEvent(structureStart, world));
    }

    public static void fireStructurePieceAdded(StructurePiece structurePiece, ServerWorld world) {
        MinecraftForge.EVENT_BUS.post((Event)new StructurePieceAddedEvent(structurePiece, world));
    }

    public static void firePlayerCraftingEvent(PlayerEntity player, ItemStack crafted, CraftingInventory craftMatrix, CraftingResultSlot slot) {
        MinecraftForge.EVENT_BUS.post((Event)new ItemCraftedEvent(player, crafted, (IInventory)craftMatrix, slot));
    }

    public static void fireMarkerHovered(PlayerEntity player, Marker marker) {
        MinecraftForge.EVENT_BUS.post((Event)new MarkerHoveredEvent(player, marker));
    }

    public static void onStructureAddedHook(StructureStart<?> structureStart, ISeedReader reader) {
        ServerWorld world = reader instanceof ServerWorld ? (ServerWorld)reader : ((WorldGenRegion)reader).func_201672_e();
        AntiqueAtlasHooks.fireStructureAdded(structureStart, world);
    }

    public static boolean onStructurePieceAddedHook(boolean get, StructurePiece structurePiece, ISeedReader reader) {
        ServerWorld world = reader instanceof ServerWorld ? (ServerWorld)reader : ((WorldGenRegion)reader).func_201672_e();
        AntiqueAtlasHooks.fireStructurePieceAdded(structurePiece, world);
        return get;
    }
}

