/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scaning;

import hunternif.mc.impl.atlas.core.TileIdMap;
import hunternif.mc.impl.atlas.core.scaning.ITileDetector;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorBase;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.registries.ForgeRegistries;

public class TileDetectorNether
extends TileDetectorBase
implements ITileDetector {
    private static final int airProbeLevel = 50;
    private static final int lavaSeaLevel = 31;
    private static final int priorityLava = 1;

    @Override
    public ResourceLocation getBiomeID(World world, IChunk chunk) {
        BiomeContainer chunkBiomes = chunk.func_225549_i_();
        if (chunkBiomes == null) {
            return null;
        }
        HashMap<ResourceLocation, Integer> biomeOccurrences = new HashMap<ResourceLocation, Integer>(ForgeRegistries.BIOMES.getKeys().size());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = chunkBiomes.func_225526_b_(x, 31, z);
                if (biome.func_201856_r() == Biome.Category.NETHER) {
                    Block seaLevelBlock = chunk.func_180495_p(new BlockPos(x, 31, z)).func_177230_c();
                    if (seaLevelBlock == Blocks.field_150353_l) {
                        TileDetectorNether.updateOccurrencesMap(biomeOccurrences, TileIdMap.TILE_LAVA, 1);
                        continue;
                    }
                    BlockState airProbeBlock = chunk.func_180495_p(new BlockPos(x, 50, z));
                    if (airProbeBlock.func_196958_f()) {
                        TileDetectorNether.updateOccurrencesMap(biomeOccurrences, TileIdMap.TILE_LAVA_SHORE, 1);
                        continue;
                    }
                    TileDetectorNether.updateOccurrencesMap(biomeOccurrences, world, biome, 1);
                    continue;
                }
                TileDetectorNether.updateOccurrencesMap(biomeOccurrences, world, biome, this.priorityForBiome(TileDetectorNether.getBiomeIdentifier(world, biome)));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (ResourceLocation)meanBiome.getKey();
    }

    @Override
    public int getScanRadius() {
        return Math.min(super.getScanRadius(), 6);
    }
}

