/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scaning;

import hunternif.mc.impl.atlas.core.scaning.ITileDetector;
import hunternif.mc.impl.atlas.core.scaning.TileDetectorBase;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;

public class TileDetectorEnd
extends TileDetectorBase
implements ITileDetector {
    @Override
    public ResourceLocation getBiomeID(World world, IChunk chunk) {
        BiomeContainer chunkBiomes = chunk.func_225549_i_();
        if (chunkBiomes == null) {
            return null;
        }
        HashMap<ResourceLocation, Integer> biomeOccurrences = new HashMap<ResourceLocation, Integer>(ForgeRegistries.BIOMES.getKeys().size());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Biome biome = chunkBiomes.func_225526_b_(x, 0, z);
                ResourceLocation id = TileDetectorEnd.getBiomeIdentifier(world, biome);
                if (id == Biomes.field_185440_P.func_240901_a_()) {
                    TileDetectorEnd.updateOccurrencesMap(biomeOccurrences, id, 1);
                    continue;
                }
                int top = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE).func_202273_a(x, z);
                BlockState topBlock = chunk.func_180495_p(new BlockPos(x, top - 1, z));
                if (topBlock.func_177230_c() == Blocks.field_150377_bs) {
                    TileDetectorEnd.updateOccurrencesMap(biomeOccurrences, world, biome, 3);
                    continue;
                }
                if (!topBlock.func_196958_f()) continue;
                TileDetectorEnd.updateOccurrencesMap(biomeOccurrences, Biomes.field_185440_P.func_240901_a_(), 1);
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (ResourceLocation)meanBiome.getKey();
    }
}

