/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scaning;

import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.core.TileIdMap;
import hunternif.mc.impl.atlas.core.scaning.ITileDetector;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TileDetectorBase
implements ITileDetector {
    private static final ResourceLocation waterPoolBiome = Biomes.field_76781_i.func_240901_a_();
    private static final int priorityRavine = 12;
    private static final int priorityWaterPool = 4;
    private static final int priorityLavaPool = 6;
    private static final int ravineMinDepth = 7;
    private static final Set<ResourceLocation> waterBiomes = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> beachBiomes = new HashSet<ResourceLocation>();
    private static final Set<ResourceLocation> swampBiomes = new HashSet<ResourceLocation>();

    public static void scanBiomeTypes() {
        for (Biome biome : ForgeRegistries.BIOMES) {
            switch (biome.func_201856_r()) {
                case BEACH: {
                    beachBiomes.add(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome));
                    break;
                }
                case RIVER: 
                case OCEAN: {
                    waterBiomes.add(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome));
                    break;
                }
                case SWAMP: {
                    swampBiomes.add(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome));
                }
            }
        }
    }

    int priorityForBiome(ResourceLocation biome) {
        if (waterBiomes.contains(biome)) {
            return 4;
        }
        if (beachBiomes.contains(biome)) {
            return 3;
        }
        return 1;
    }

    protected static ResourceLocation getBiomeIdentifier(World world, Biome biome) {
        return world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
    }

    protected static void updateOccurrencesMap(Map<ResourceLocation, Integer> map, ResourceLocation biome, int weight) {
        int occurrence = map.getOrDefault(biome, 0) + weight;
        map.put(biome, occurrence);
    }

    protected static void updateOccurrencesMap(Map<ResourceLocation, Integer> map, World world, Biome biome, int weight) {
        ResourceLocation id = TileDetectorBase.getBiomeIdentifier(world, biome);
        int occurrence = map.getOrDefault(id, 0) + weight;
        map.put(id, occurrence);
    }

    @Override
    public int getScanRadius() {
        return (Integer)AntiqueAtlasConfig.scanRadius.get();
    }

    @Override
    public ResourceLocation getBiomeID(World world, IChunk chunk) {
        BiomeContainer chunkBiomes = chunk.func_225549_i_();
        HashMap<ResourceLocation, Integer> biomeOccurrences = new HashMap<ResourceLocation, Integer>(ForgeRegistries.BIOMES.getKeys().size());
        if (chunkBiomes == null) {
            return null;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height;
                int y;
                Biome biome = chunkBiomes.func_225526_b_(x, 0, z);
                if (((Boolean)AntiqueAtlasConfig.doScanPonds.get()).booleanValue() && (y = chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING).func_202273_a(x, z)) > 0) {
                    Block topBlock = chunk.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
                    if (topBlock == Blocks.field_150355_j) {
                        if (swampBiomes.contains(TileDetectorBase.getBiomeIdentifier(world, biome))) {
                            TileDetectorBase.updateOccurrencesMap(biomeOccurrences, TileIdMap.SWAMP_WATER, 4);
                        } else {
                            TileDetectorBase.updateOccurrencesMap(biomeOccurrences, waterPoolBiome, 4);
                        }
                    } else if (topBlock == Blocks.field_150353_l) {
                        TileDetectorBase.updateOccurrencesMap(biomeOccurrences, TileIdMap.TILE_LAVA, 6);
                    }
                }
                if (((Boolean)AntiqueAtlasConfig.doScanRavines.get()).booleanValue() && (height = chunk.func_217303_b(Heightmap.Type.MOTION_BLOCKING).func_202273_a(x, z)) > 0 && height < world.func_181545_F() - 7) {
                    TileDetectorBase.updateOccurrencesMap(biomeOccurrences, TileIdMap.TILE_RAVINE, 12);
                }
                TileDetectorBase.updateOccurrencesMap(biomeOccurrences, world, biome, this.priorityForBiome(TileDetectorBase.getBiomeIdentifier(world, biome)));
            }
        }
        if (biomeOccurrences.isEmpty()) {
            return null;
        }
        Map.Entry meanBiome = Collections.max(biomeOccurrences.entrySet(), Comparator.comparingInt(Map.Entry::getValue));
        return (ResourceLocation)meanBiome.getKey();
    }
}

