/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.texture;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ATexture
implements ITexture {
    final ResourceLocation texture;
    final boolean autobind;
    private final RenderType LAYER;

    public ATexture(ResourceLocation texture) {
        this(texture, true);
    }

    public ATexture(ResourceLocation texture, boolean autobind) {
        this.texture = texture;
        this.autobind = autobind;
        this.LAYER = RenderType.func_228658_l_((ResourceLocation)texture);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Override
    public void bind() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
    }

    @Override
    public void draw(MatrixStack matrices, int x, int y) {
        this.draw(matrices, x, y, this.width(), this.height());
    }

    @Override
    public void draw(MatrixStack matrices, int x, int y, int width, int height) {
        this.draw(matrices, x, y, width, height, 0, 0, this.width(), this.height());
    }

    @Override
    public void draw(MatrixStack matrices, int x, int y, int u, int v, int regionWidth, int regionHeight) {
        this.draw(matrices, x, y, regionWidth, regionHeight, u, v, regionWidth, regionHeight);
    }

    @Override
    public void draw(MatrixStack matrices, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight) {
        if (this.autobind) {
            this.bind();
        }
        AbstractGui.func_238466_a_((MatrixStack)matrices, (int)x, (int)y, (int)width, (int)height, (float)u, (float)v, (int)regionWidth, (int)regionHeight, (int)this.width(), (int)this.height());
    }

    @Override
    public void drawWithLight(IRenderTypeBuffer consumer, MatrixStack matrices, int x, int y, int width, int height, int light) {
        this.drawWithLight(consumer, matrices, x, y, width, height, 0, 0, this.width(), this.height(), light);
    }

    @Override
    public void drawWithLight(IRenderTypeBuffer consumer, MatrixStack matrices, int x, int y, int width, int height, int u, int v, int regionWidth, int regionHeight, int light) {
        if (this.autobind) {
            this.bind();
        }
        this.drawTexturedQuadWithLight(consumer, matrices.func_227866_c_().func_227870_a_(), x, x + width, y, y + height, ((float)u + 0.0f) / (float)this.width(), ((float)u + (float)regionWidth) / (float)this.width(), ((float)v + 0.0f) / (float)this.height(), ((float)v + (float)regionHeight) / (float)this.height(), light);
    }

    private void drawTexturedQuadWithLight(IRenderTypeBuffer vertexConsumer, Matrix4f matrices, int x0, int x1, int y0, int y1, float u0, float u1, float v0, float v1, int light) {
        IVertexBuilder consumer = vertexConsumer.getBuffer(this.LAYER);
        consumer.func_227888_a_(matrices, (float)x0, (float)y1, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(u0, v1).func_227886_a_(light).func_181675_d();
        consumer.func_227888_a_(matrices, (float)x1, (float)y1, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(u1, v1).func_227886_a_(light).func_181675_d();
        consumer.func_227888_a_(matrices, (float)x1, (float)y0, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(u1, v0).func_227886_a_(light).func_181675_d();
        consumer.func_227888_a_(matrices, (float)x0, (float)y0, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_(u0, v0).func_227886_a_(light).func_181675_d();
    }
}

