/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Features;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public class TileTextureMap {
    private static final TileTextureMap INSTANCE = new TileTextureMap();
    private final Map<ResourceLocation, TextureSet> textureMap = new HashMap<ResourceLocation, TextureSet>();

    public static TileTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(Biome biome, TextureSet textureSet) {
        this.setTexture(WorldGenRegistries.field_243657_i.func_177774_c((Object)biome), textureSet);
    }

    public void setTexture(ResourceLocation tileId, TextureSet textureSet) {
        if (textureSet == null) {
            if (this.textureMap.remove(tileId) != null) {
                Log.warn("Removing old texture for %d", tileId);
            }
            return;
        }
        this.textureMap.put(tileId, textureSet);
    }

    public TextureSet getDefaultTexture() {
        return TextureSetMap.instance().getByName(AntiqueAtlasMod.id("test"));
    }

    private void autoRegister(Biome biome) {
        if (biome == null) {
            Log.warn("Biome is null", new Object[0]);
            return;
        }
        switch (biome.func_201856_r()) {
            case SWAMP: {
                this.setTexture(biome, biome.func_185360_m() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("swamp_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("swamp")));
                break;
            }
            case OCEAN: 
            case RIVER: {
                this.setTexture(biome, biome.func_201851_b() == Biome.RainType.SNOW ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("ice")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("water")));
                break;
            }
            case BEACH: {
                this.setTexture(biome, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("shore")));
                break;
            }
            case JUNGLE: {
                this.setTexture(biome, biome.func_185360_m() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("jungle_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("jungle")));
                break;
            }
            case SAVANNA: {
                this.setTexture(biome, biome.func_185355_j() >= 1.0f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("plateau_savanna")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("savanna")));
                break;
            }
            case MESA: {
                this.setTexture(biome, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("plateau_mesa")));
                break;
            }
            case FOREST: {
                this.setTexture(biome, biome.func_201851_b() == Biome.RainType.SNOW ? (biome.func_185360_m() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("snow_pines_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("snow_pines"))) : (biome.func_185360_m() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("forest_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("forest"))));
                break;
            }
            case PLAINS: {
                this.setTexture(biome, biome.func_201851_b() == Biome.RainType.SNOW ? (biome.func_185360_m() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("snow_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("snow"))) : (biome.func_185360_m() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("plains"))));
                break;
            }
            case ICY: {
                this.setTexture(biome, biome.func_185360_m() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("mountains_snow_caps")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("ice_spikes")));
                break;
            }
            case DESERT: {
                this.setTexture(biome, biome.func_185360_m() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("desert_hills")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("desert")));
                break;
            }
            case TAIGA: {
                this.setTexture(biome, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("snow")));
                break;
            }
            case EXTREME_HILLS: {
                this.setTexture(biome, biome.func_185360_m() >= 0.25f ? TextureSetMap.instance().getByName(AntiqueAtlasMod.id("mountains")) : TextureSetMap.instance().getByName(AntiqueAtlasMod.id("hills")));
                break;
            }
            case THEEND: {
                List features = biome.func_242440_e().func_242498_c();
                boolean has_chorus_plant = features.stream().anyMatch(supplier -> supplier.stream().anyMatch(step -> step.get() == Features.field_243944_d));
                if (has_chorus_plant) {
                    this.setTexture(biome, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("end_island_plants")));
                    break;
                }
                this.setTexture(biome, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("end_island")));
                break;
            }
            case MUSHROOM: {
                this.setTexture(biome, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("mushroom")));
            }
            case NETHER: {
                this.setTexture(biome, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("soul_sand_valley")));
            }
            case NONE: {
                this.setTexture(biome, TextureSetMap.instance().getByName(AntiqueAtlasMod.id("end_void")));
                break;
            }
            default: {
                Log.warn("Couldn't auto-registered standard texture set for biome %s", ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).toString());
                return;
            }
        }
        if (this.textureMap.get(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome)) != null) {
            Log.info("Auto-registered standard texture set for biome %s: %s", ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).toString(), this.textureMap.get((Object)ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome)).name);
        } else {
            Log.error("Failed to auto-register a standard texture set for the biome '%s'. This is most likely caused by errors in the TextureSet configurations, check your resource packs first before reporting it as an issue!", ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome).toString());
        }
    }

    public void checkRegistration(Biome biome) {
        if (!this.isRegistered(biome)) {
            this.autoRegister(biome);
        }
    }

    private void checkRegistration(ResourceLocation id) {
        if (!this.isRegistered(id)) {
            this.setTexture(id, this.getDefaultTexture());
        }
    }

    public boolean isRegistered(Biome biome) {
        return this.isRegistered(WorldGenRegistries.field_243657_i.func_177774_c((Object)biome));
    }

    public boolean isRegistered(ResourceLocation id) {
        return this.textureMap.containsKey(id);
    }

    public TextureSet getTextureSet(ResourceLocation tile) {
        if (tile == null) {
            return this.getDefaultTexture();
        }
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(tile);
        if (biome != null) {
            this.checkRegistration(biome);
        } else {
            this.checkRegistration(tile);
        }
        return this.textureMap.get(tile);
    }

    public ITexture getTexture(SubTile subTile) {
        return this.getTextureSet(subTile.tile).getTexture(subTile.variationNumber);
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, TextureSet> entry : this.textureMap.entrySet()) {
            Arrays.stream(entry.getValue().textures).forEach(iTexture -> list.add(iTexture.getTexture()));
        }
        return list;
    }
}

