/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.forge.IResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileTextureConfig
implements IResourceReloadListener<Map<ResourceLocation, ResourceLocation>> {
    private static final int VERSION = 1;
    private static final JsonParser PARSER = new JsonParser();
    private final TileTextureMap tileTextureMap;
    private final TextureSetMap textureSetMap;

    public TileTextureConfig(TileTextureMap biomeTextureMap, TextureSetMap textureSetMap) {
        this.tileTextureMap = biomeTextureMap;
        this.textureSetMap = textureSetMap;
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, ResourceLocation>> load(IResourceManager manager, IProfiler profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, ResourceLocation> map = new HashMap<ResourceLocation, ResourceLocation>();
            try {
                for (ResourceLocation id : manager.func_199003_a("atlas/tiles", s -> s.endsWith(".json"))) {
                    ResourceLocation tile_id = new ResourceLocation(id.func_110624_b(), id.func_110623_a().replace("atlas/tiles/", "").replace(".json", ""));
                    try {
                        IResource resource = manager.func_199002_a(id);
                        InputStream stream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            InputStreamReader reader = new InputStreamReader(stream);
                            Throwable throwable2 = null;
                            try {
                                JsonObject object = PARSER.parse((Reader)reader).getAsJsonObject();
                                int version = object.getAsJsonPrimitive("version").getAsInt();
                                if (version != 1) {
                                    AntiqueAtlasMod.LOG.warn("The tile " + tile_id + " is in the wrong version! Skipping.");
                                    continue;
                                }
                                ResourceLocation texture_set = new ResourceLocation(object.get("texture_set").getAsString());
                                map.put(tile_id, texture_set);
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                reader.close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        AntiqueAtlasMod.LOG.warn("Error reading tile mapping " + tile_id + "!", (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read tile mappings!", new Object[0]);
            }
            return map;
        });
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, ResourceLocation> tileMap, IResourceManager manager, IProfiler profiler, Executor executor) {
        for (Map.Entry<ResourceLocation, ResourceLocation> entry : tileMap.entrySet()) {
            ResourceLocation tile_id = entry.getKey();
            ResourceLocation texture_set = entry.getValue();
            TextureSet set = this.textureSetMap.getByName(entry.getValue());
            if (set == null) {
                AntiqueAtlasMod.LOG.error("Missing texture set `{}` for tile `{}`. Using default.", (Object)texture_set, (Object)tile_id);
                set = this.tileTextureMap.getDefaultTexture();
            }
            this.tileTextureMap.setTexture(entry.getKey(), set);
            Log.info("Using texture set %s for tile %s", set.name, tile_id);
        }
        return CompletableFuture.runAsync(() -> {});
    }
}

