/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureSet
implements Comparable<TextureSet> {
    public final ResourceLocation name;
    public final ITexture[] textures;
    private final Set<ResourceLocation> stitchTo = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> stitchToHorizontal = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> stitchToVertical = new HashSet<ResourceLocation>();
    private final ResourceLocation[] texturePaths;
    private boolean stitchesToNull = false;
    private boolean anisotropicStitching = false;

    public TextureSet(ResourceLocation name, ResourceLocation ... textures) {
        this.name = name;
        this.texturePaths = textures;
        this.textures = new ITexture[textures.length];
    }

    public TextureSet stitchesToNull() {
        this.stitchesToNull = true;
        return this;
    }

    public TextureSet stitchTo(ResourceLocation ... textureSets) {
        Collections.addAll(this.stitchTo, textureSets);
        Collections.addAll(this.stitchToHorizontal, textureSets);
        Collections.addAll(this.stitchToVertical, textureSets);
        return this;
    }

    public TextureSet stitchToHorizontal(ResourceLocation ... textureSets) {
        this.anisotropicStitching = true;
        Collections.addAll(this.stitchToHorizontal, textureSets);
        return this;
    }

    public TextureSet stitchToVertical(ResourceLocation ... textureSets) {
        this.anisotropicStitching = true;
        Collections.addAll(this.stitchToVertical, textureSets);
        return this;
    }

    public boolean shouldStitchTo(TextureSet toSet) {
        return toSet == this || this.stitchesToNull && toSet == null || this.stitchTo.contains(toSet.name);
    }

    public boolean shouldStitchToHorizontally(TextureSet toSet) {
        if (toSet == this || this.stitchesToNull && toSet == null) {
            return true;
        }
        if (this.anisotropicStitching) {
            return this.stitchToHorizontal.contains(toSet.name);
        }
        return this.stitchTo.contains(toSet.name);
    }

    public boolean shouldStitchToVertically(TextureSet toSet) {
        if (toSet == this || this.stitchesToNull && toSet == null) {
            return true;
        }
        if (this.anisotropicStitching) {
            return this.stitchToVertical.contains(toSet.name);
        }
        return this.stitchTo.contains(toSet.name);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TextureSet)) {
            return false;
        }
        TextureSet set = (TextureSet)obj;
        return this.name.equals((Object)set.name);
    }

    public ITexture getTexture(int variationNumber) {
        return this.textures[variationNumber % this.textures.length];
    }

    public ResourceLocation[] getTexturePaths() {
        return this.texturePaths;
    }

    public void loadTextures() {
        for (int i = 0; i < this.texturePaths.length; ++i) {
            if (!Textures.TILE_TEXTURES_MAP.containsKey(this.texturePaths[i])) {
                throw new RuntimeException("Couldn't find the specified texture: " + this.texturePaths[i].toString());
            }
            this.textures[i] = Textures.TILE_TEXTURES_MAP.get(this.texturePaths[i]);
        }
    }

    public void checkStitching() {
        this.stitchTo.stream().filter(identifier -> !TextureSetMap.isRegistered(identifier)).forEach(identifier -> Log.error("The texture set %s tries to stitch to %s, which does not exists.", this.name, identifier));
        this.stitchToVertical.stream().filter(identifier -> !TextureSetMap.isRegistered(identifier)).forEach(identifier -> Log.error("The texture set %s tries to stitch vertically to %s, which does not exists.", this.name, identifier));
        this.stitchToHorizontal.stream().filter(identifier -> !TextureSetMap.isRegistered(identifier)).forEach(identifier -> Log.error("The texture set %s tries to stitch horizontally to %s, which does not exists.", this.name, identifier));
    }

    @Override
    public int compareTo(TextureSet textureSet) {
        return this.name.toString().compareTo(textureSet.name.toString());
    }

    static class TextureSetShore
    extends TextureSet {
        public final ResourceLocation waterName;
        private TextureSet water;

        TextureSetShore(ResourceLocation name, ResourceLocation water, ResourceLocation ... textures) {
            super(name, textures);
            this.waterName = water;
        }

        public void loadWater() {
            this.water = TextureSetMap.instance().getByName(this.waterName);
        }

        @Override
        public boolean shouldStitchToHorizontally(TextureSet otherSet) {
            return otherSet == this || !this.water.shouldStitchToHorizontally(otherSet);
        }

        @Override
        public boolean shouldStitchToVertically(TextureSet otherSet) {
            return otherSet == this || !this.water.shouldStitchToVertically(otherSet);
        }
    }
}

