/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.texture.ITexture;
import hunternif.mc.impl.atlas.client.texture.TileTexture;
import hunternif.mc.impl.atlas.forge.IResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureConfig
implements IResourceReloadListener<Map<ResourceLocation, ITexture>> {
    private final Map<ResourceLocation, ITexture> texture_map;

    public TextureConfig(Map<ResourceLocation, ITexture> texture_map) {
        this.texture_map = texture_map;
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, ITexture>> load(IResourceManager manager, IProfiler profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, TileTexture> textures = new HashMap<ResourceLocation, TileTexture>();
            try {
                for (ResourceLocation id : manager.func_199003_a("textures/gui/tiles", s -> s.endsWith(".png"))) {
                    ResourceLocation texture_id = new ResourceLocation(id.func_110624_b(), id.func_110623_a().replace("textures/gui/tiles/", "").replace(".png", ""));
                    AntiqueAtlasMod.LOG.info("Found new Texture: " + texture_id);
                    textures.put(texture_id, new TileTexture(id));
                }
            }
            catch (Throwable e) {
                AntiqueAtlasMod.LOG.warn("Failed to read textures!", e);
            }
            return textures;
        });
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, ITexture> textures, IResourceManager manager, IProfiler profiler, Executor executor) {
        for (Map.Entry<ResourceLocation, ITexture> entry : textures.entrySet()) {
            this.texture_map.put(entry.getKey(), entry.getValue());
            Log.info("Loaded texture %s with path %s", entry.getKey(), entry.getValue().getTexture());
        }
        return CompletableFuture.runAsync(() -> {});
    }
}

