/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hunternif.mc.api.client.AtlasClientAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasConfig;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.impl.atlas.client.SetTileRenderer;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.SubTileQuartet;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileRenderIterator;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.client.gui.GuiAtlas;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.item.AtlasItem;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.registry.MarkerRenderInfo;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.Rect;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OverlayRenderer
extends AbstractGui {
    private static final int CHUNK_SIZE = 16;
    private static final float INNER_ELEMENTS_SCALE_FACTOR = 1.9f;
    private PlayerEntity player;
    private World world;

    public void drawOverlay(MatrixStack matrices, IRenderTypeBuffer vertexConsumer, int light) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiAtlas) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.world = Minecraft.func_71410_x().field_71441_e;
        ItemStack mainHandStack = this.player.func_184614_ca();
        ItemStack offHandStack = this.player.func_184592_cb();
        Integer atlasID = null;
        if (!mainHandStack.func_190926_b() && mainHandStack.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
            atlasID = AtlasItem.getAtlasID(mainHandStack);
        } else if (!offHandStack.func_190926_b() && offHandStack.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
            atlasID = AtlasItem.getAtlasID(offHandStack);
        }
        if (atlasID != null) {
            this.drawMinimap(matrices, atlasID, vertexConsumer, light);
        }
        atlasID = null;
    }

    private void drawMinimap(MatrixStack matrices, int atlasID, IRenderTypeBuffer buffer, int light) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.0, 0.0, 0.01);
        Textures.BOOK.drawWithLight(buffer, matrices, 0, 0, 465, 327, light);
        matrices.func_227865_b_();
        matrices.func_227860_a_();
        matrices.func_227862_a_(1.9f, 1.9f, 1.0f);
        this.drawTiles(buffer, matrices, atlasID, light);
        matrices.func_227861_a_(0.0, 0.0, -0.01);
        if ((Integer)AntiqueAtlasConfig.markerSize.get() > 0) {
            this.drawMarkers(buffer, matrices, atlasID, light);
        }
        matrices.func_227865_b_();
        matrices.func_227861_a_(0.0, 0.0, -0.02);
        this.drawPlayer(buffer, matrices, light);
        matrices.func_227861_a_(0.0, 0.0, -0.01);
        Textures.BOOK_FRAME.drawWithLight(buffer, matrices, 0, 0, 465, 327, light);
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    private void drawTiles(IRenderTypeBuffer buffer, MatrixStack matrices, int atlasID, int light) {
        Rect iteratorScope = this.getChunkCoverage(this.player.func_213303_ch());
        TileRenderIterator iter = AtlasClientAPI.getTileAPI().getTiles(this.world, atlasID, iteratorScope, 1);
        Vector3d chunkPosition = this.player.func_213303_ch().func_216372_d(0.0625, 0.0625, 0.0625);
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        SetTileRenderer renderer = new SetTileRenderer(buffer, matrices, (Integer)AntiqueAtlasConfig.tileSize.get() / 2, light);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                float relativeChunkPositionX = (float)((double)subtile.x / 2.0 + (double)iteratorScope.minX - chunkPosition.field_72450_a);
                float relativeChunkPositionY = (float)((double)subtile.y / 2.0 + (double)iteratorScope.minY - chunkPosition.field_72449_c);
                renderer.addTileCorner(TileTextureMap.instance().getTexture(subtile).getTexture(), shapeMiddleX + (int)Math.floor(relativeChunkPositionX * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue()), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue()), subtile.getTextureU(), subtile.getTextureV());
            }
        }
        renderer.draw();
    }

    private void drawMarkers(IRenderTypeBuffer buffer, MatrixStack matrices, int atlasID, int light) {
        WorldData biomeData = AntiqueAtlasMod.tileData.getData(atlasID, this.world).getWorldData((RegistryKey<World>)this.world.func_234923_W_());
        DimensionMarkersData globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInWorld((RegistryKey<World>)this.world.func_234923_W_());
        this.drawMarkersData(buffer, matrices, globalMarkersData, biomeData, light);
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(atlasID, (World)Minecraft.func_71410_x().field_71441_e);
        if (markersData != null) {
            DimensionMarkersData localMarkersData = markersData.getMarkersDataInWorld((RegistryKey<World>)this.world.func_234923_W_());
            this.drawMarkersData(buffer, matrices, localMarkersData, biomeData, light);
        }
    }

    private void drawPlayer(IRenderTypeBuffer buffer, MatrixStack matrices, int light) {
        matrices.func_227860_a_();
        matrices.func_227861_a_(232.0, 163.0, 0.0);
        matrices.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, this.player.func_70079_am() + 180.0f, true));
        matrices.func_227861_a_((double)(-((Integer)AntiqueAtlasConfig.playerIconWidth.get()).intValue()) / 2.0, (double)(-((Integer)AntiqueAtlasConfig.playerIconHeight.get()).intValue()) / 2.0, 0.0);
        Textures.PLAYER.drawWithLight(buffer, matrices, 0, 0, (Integer)AntiqueAtlasConfig.playerIconWidth.get(), (Integer)AntiqueAtlasConfig.playerIconHeight.get(), light);
        matrices.func_227865_b_();
    }

    private void drawMarkersData(IRenderTypeBuffer buffer, MatrixStack matrices, DimensionMarkersData markersData, WorldData biomeData, int light) {
        Rect mcchunks = this.getChunkCoverage(this.player.func_213303_ch());
        Rect chunks = new Rect(mcchunks.minX / 8, mcchunks.minY / 8, (int)Math.ceil((float)mcchunks.maxX / 8.0f), (int)Math.ceil((float)mcchunks.maxY / 8.0f));
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        Vector3d chunkPosition = this.player.func_213303_ch().func_216372_d(0.0625, 0.0625, 0.0625);
        for (int x = chunks.minX; x <= chunks.maxX; ++x) {
            for (int z = chunks.minY; z <= chunks.maxY; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(x, z);
                if (markers == null) continue;
                for (Marker marker : markers) {
                    float relativeChunkPositionX = (float)((double)marker.getChunkX() - chunkPosition.field_72450_a);
                    float relativeChunkPositionY = (float)((double)marker.getChunkZ() - chunkPosition.field_72449_c);
                    this.renderMarker(buffer, matrices, marker, shapeMiddleX + (int)Math.floor(relativeChunkPositionX * 8.0f), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * 8.0f), biomeData, light);
                }
            }
        }
    }

    private void renderMarker(IRenderTypeBuffer buffer, MatrixStack matrices, Marker marker, int x, int y, WorldData biomeData, int light) {
        int tileHalfSize = 2;
        if (x + tileHalfSize > 240 || x - tileHalfSize < 3 || y + tileHalfSize >= 166 || y - tileHalfSize < 0) {
            return;
        }
        if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        MarkerType type = (MarkerType)MarkerType.REGISTRY.func_82594_a(marker.getType());
        MarkerRenderInfo info = type.getRenderInfo(1.0, ((Integer)AntiqueAtlasConfig.tileSize.get()).intValue(), 1.0);
        info.tex.drawWithLight(buffer, matrices, x - 8 + 4, y - 8 + 4, 16, 16, light);
    }

    private Rect getChunkCoverage(Vector3d position) {
        int minChunkX = (int)Math.floor(position.field_72450_a / 16.0 - (double)(310.0f / (4.0f * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue())));
        int minChunkY = (int)Math.floor(position.field_72449_c / 16.0 - (double)(218.0f / (4.0f * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue())));
        int maxChunkX = (int)Math.ceil(position.field_72450_a / 16.0 + (double)(310.0f / (4.0f * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue())));
        int maxChunkY = (int)Math.ceil(position.field_72449_c / 16.0 + (double)(218.0f / (4.0f * (float)((Integer)AntiqueAtlasConfig.tileSize.get()).intValue())));
        return new Rect(minChunkX -= 4, minChunkY -= 3, maxChunkX += 4, maxChunkY += 2);
    }
}

