/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.api.impl;

import hunternif.mc.api.TileAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileDataStorage;
import hunternif.mc.impl.atlas.network.packet.c2s.play.PutTileC2SPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.CustomTileInfoS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.DeleteCustomGlobalTileS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.PutTileS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TileApiImpl
implements TileAPI {
    @Override
    public void putTile(World world, int atlasID, ResourceLocation tile, int chunkX, int chunkZ) {
        if (tile == null) {
            Log.error("Attempted to put custom tile with null name", new Object[0]);
            return;
        }
        RegistryKey dimension = world.func_234923_W_();
        if (world.field_72995_K) {
            new PutTileC2SPacket(atlasID, chunkX, chunkZ, tile).send();
        } else {
            AtlasData data = AntiqueAtlasMod.tileData.getData(atlasID, world);
            data.setTile((RegistryKey<World>)dimension, chunkX, chunkZ, tile);
            for (PlayerEntity syncedPlayer : data.getSyncedPlayers()) {
                new PutTileS2CPacket(atlasID, (RegistryKey<World>)dimension, chunkX, chunkZ, tile).send((ServerPlayerEntity)syncedPlayer);
            }
        }
    }

    @Override
    public ResourceLocation getTile(World world, int atlasID, int chunkX, int chunkZ) {
        AtlasData data = AntiqueAtlasMod.tileData.getData(atlasID, world);
        return data.getWorldData((RegistryKey<World>)world.func_234923_W_()).getTile(chunkX, chunkZ);
    }

    @Override
    public void putGlobalTile(World world, ResourceLocation tileId, int chunkX, int chunkZ) {
        if (tileId == null) {
            Log.error("Attempted to put global tile with null name", new Object[0]);
            return;
        }
        if (world.field_72995_K) {
            Log.warn("Client attempted to put global tile", new Object[0]);
            return;
        }
        TileDataStorage data = AntiqueAtlasMod.globalTileData.getData(world);
        data.setTile(chunkX, chunkZ, tileId);
        new CustomTileInfoS2CPacket((RegistryKey<World>)world.func_234923_W_(), chunkX, chunkZ, tileId).send((ServerWorld)world);
    }

    @Override
    public ResourceLocation getGlobalTile(World world, int chunkX, int chunkZ) {
        TileDataStorage data = AntiqueAtlasMod.globalTileData.getData(world);
        return data.getTile(chunkX, chunkZ);
    }

    @Override
    public void deleteGlobalTile(World world, int chunkX, int chunkZ) {
        if (world.field_72995_K) {
            Log.warn("Client attempted to delete global tile", new Object[0]);
            return;
        }
        TileDataStorage data = AntiqueAtlasMod.globalTileData.getData(world);
        if (data.getTile(chunkX, chunkZ) != null) {
            data.removeTile(chunkX, chunkZ);
            new DeleteCustomGlobalTileS2CPacket((RegistryKey<World>)world.func_234923_W_(), chunkX, chunkZ).send((ServerWorld)world);
        }
    }
}

