/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.api.impl;

import hunternif.mc.api.MarkerAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.marker.GlobalMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.network.packet.c2s.play.DeleteMarkerRequestC2SPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.DeleteMarkerResponseS2CPacket;
import hunternif.mc.impl.atlas.network.packet.s2c.play.MarkersS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MarkerApiImpl
implements MarkerAPI {
    private static final int GLOBAL = -1;

    @Override
    @Nullable
    public Marker putMarker(@Nonnull World world, boolean visibleAhead, int atlasID, ResourceLocation marker, ITextComponent label, int x, int z) {
        return this.doPutMarker(world, visibleAhead, atlasID, marker, label, x, z);
    }

    @Override
    @Nullable
    public Marker putGlobalMarker(@Nonnull World world, boolean visibleAhead, ResourceLocation marker, ITextComponent label, int x, int z) {
        return this.doPutMarker(world, visibleAhead, -1, marker, label, x, z);
    }

    private Marker doPutMarker(World world, boolean visibleAhead, int atlasID, ResourceLocation markerId, ITextComponent label, int x, int z) {
        Marker marker = null;
        if (!world.field_72995_K && world.func_73046_m() != null) {
            GlobalMarkersData data = atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
            marker = ((MarkersData)data).createAndSaveMarker(markerId, (RegistryKey<World>)world.func_234923_W_(), x, z, visibleAhead, label);
            new MarkersS2CPacket(atlasID, (RegistryKey<World>)world.func_234923_W_(), Collections.singleton(marker)).send((ServerWorld)world);
        }
        return marker;
    }

    @Override
    public void deleteMarker(@Nonnull World world, int atlasID, int markerID) {
        this.doDeleteMarker(world, atlasID, markerID);
    }

    @Override
    public void deleteGlobalMarker(@Nonnull World world, int markerID) {
        this.doDeleteMarker(world, -1, markerID);
    }

    private void doDeleteMarker(World world, int atlasID, int markerID) {
        if (world.field_72995_K) {
            if (atlasID == -1) {
                Log.warn("Client tried to delete a global marker!", new Object[0]);
            } else {
                new DeleteMarkerRequestC2SPacket(atlasID, markerID).send();
            }
        } else {
            GlobalMarkersData data = atlasID == -1 ? AntiqueAtlasMod.globalMarkersData.getData() : AntiqueAtlasMod.markersData.getMarkersData(atlasID, world);
            data.removeMarker(markerID);
            new DeleteMarkerResponseS2CPacket(atlasID, markerID).send(world.func_73046_m());
        }
    }
}

