/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas;

import hunternif.mc.impl.atlas.client.TextureConfig;
import hunternif.mc.impl.atlas.client.TextureSetConfig;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileTextureConfig;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.marker.MarkerTextureConfig;
import hunternif.mc.impl.atlas.registry.MarkerType;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
implements ISelectiveResourceReloadListener {
    public void initClient() {
        IReloadableResourceManager resourceManager = Minecraft.func_71410_x().field_110451_am;
        TextureConfig textureConfig = new TextureConfig(Textures.TILE_TEXTURES_MAP);
        resourceManager.func_219534_a((IFutureReloadListener)textureConfig);
        TextureSetMap textureSetMap = TextureSetMap.instance();
        TextureSetConfig textureSetConfig = new TextureSetConfig(textureSetMap);
        resourceManager.func_219534_a((IFutureReloadListener)textureSetConfig);
        TileTextureMap tileTextureMap = TileTextureMap.instance();
        TileTextureConfig tileTextureConfig = new TileTextureConfig(tileTextureMap, textureSetMap);
        resourceManager.func_219534_a((IFutureReloadListener)tileTextureConfig);
        resourceManager.func_219534_a((IFutureReloadListener)this);
        tileTextureMap = TileTextureMap.instance();
        MarkerTextureConfig markerTextureConfig = new MarkerTextureConfig();
        resourceManager.func_219534_a((IFutureReloadListener)markerTextureConfig);
        for (MarkerType type : MarkerType.REGISTRY) {
            type.initMips();
        }
    }

    private void assignBiomeTextures() {
        for (Biome biome : WorldGenRegistries.field_243657_i) {
            TileTextureMap.instance().checkRegistration(biome);
        }
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        this.func_195410_a(resourceManager);
    }

    public void func_195410_a(IResourceManager resourceManager) {
        for (MarkerType type : MarkerType.REGISTRY) {
            type.initMips();
        }
        this.assignBiomeTextures();
    }
}

