/*
 * Decompiled with CFR 0.152.
 */
package lib.okhttp3.internal.connection;

import java.io.IOException;
import lib.okhttp3.Interceptor;
import lib.okhttp3.OkHttpClient;
import lib.okhttp3.Request;
import lib.okhttp3.Response;
import lib.okhttp3.internal.connection.RealConnection;
import lib.okhttp3.internal.connection.StreamAllocation;
import lib.okhttp3.internal.http.HttpCodec;
import lib.okhttp3.internal.http.RealInterceptorChain;

public final class ConnectInterceptor
implements Interceptor {
    public final OkHttpClient client;

    public ConnectInterceptor(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Request request = realChain.request();
        StreamAllocation streamAllocation = realChain.streamAllocation();
        boolean doExtensiveHealthChecks = !request.method().equals("GET");
        HttpCodec httpCodec = streamAllocation.newStream(this.client, chain, doExtensiveHealthChecks);
        RealConnection connection = streamAllocation.connection();
        return realChain.proceed(request, streamAllocation, httpCodec, connection);
    }
}

