/*
 * Decompiled with CFR 0.152.
 */
package lib.net.dv8tion.jda.internal.utils;

import java.io.IOException;
import lib.javax.annotation.Nonnull;
import lib.javax.annotation.Nullable;
import lib.okhttp3.MediaType;
import lib.okhttp3.RequestBody;
import lib.okio.BufferedSink;
import lib.okio.BufferedSource;
import lib.okio.Okio;
import lib.okio.Source;

public class BufferedRequestBody
extends RequestBody {
    private final Source source;
    private final MediaType type;
    private byte[] data;

    public BufferedRequestBody(Source source, MediaType type) {
        this.source = source;
        this.type = type;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return this.type;
    }

    @Override
    public void writeTo(@Nonnull BufferedSink sink) throws IOException {
        if (this.data != null) {
            sink.write(this.data);
            return;
        }
        try (BufferedSource s = Okio.buffer(this.source);){
            this.data = s.readByteArray();
            sink.write(this.data);
        }
    }
}

