/*
 * Decompiled with CFR 0.152.
 */
package lib.net.dv8tion.jda.internal.interactions;

import java.util.ArrayList;
import java.util.List;
import lib.javax.annotation.Nonnull;
import lib.javax.annotation.Nullable;
import lib.net.dv8tion.jda.api.interactions.components.Component;
import lib.net.dv8tion.jda.api.interactions.components.selections.SelectOption;
import lib.net.dv8tion.jda.api.interactions.components.selections.SelectionMenu;
import lib.net.dv8tion.jda.api.utils.data.DataArray;
import lib.net.dv8tion.jda.api.utils.data.DataObject;

public class SelectionMenuImpl
implements SelectionMenu {
    private final String id;
    private final String placeholder;
    private final int minValues;
    private final int maxValues;
    private final boolean disabled;
    private final List<SelectOption> options;

    public SelectionMenuImpl(DataObject data) {
        this(data.getString("custom_id"), data.getString("placeholder", null), data.getInt("min_values", 1), data.getInt("max_values", 1), data.getBoolean("disabled"), SelectionMenuImpl.parseOptions(data.getArray("options")));
    }

    public SelectionMenuImpl(String id, String placeholder, int minValues, int maxValues, boolean disabled, List<SelectOption> options) {
        this.id = id;
        this.placeholder = placeholder;
        this.minValues = minValues;
        this.maxValues = maxValues;
        this.disabled = disabled;
        this.options = options;
    }

    private static List<SelectOption> parseOptions(DataArray array) {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>(array.length());
        array.stream(DataArray::getObject).map(SelectOption::fromData).forEach(options::add);
        return options;
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return Component.Type.SELECTION_MENU;
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public int getMinValues() {
        return this.minValues;
    }

    @Override
    public int getMaxValues() {
        return this.maxValues;
    }

    @Override
    @Nonnull
    public List<SelectOption> getOptions() {
        return this.options;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject data = DataObject.empty();
        data.put("type", 3);
        data.put("custom_id", this.id);
        data.put("min_values", this.minValues);
        data.put("max_values", this.maxValues);
        data.put("disabled", this.disabled);
        data.put("options", DataArray.fromCollection(this.options));
        if (this.placeholder != null) {
            data.put("placeholder", this.placeholder);
        }
        return data;
    }
}

