/*
 * Decompiled with CFR 0.152.
 */
package lib.net.dv8tion.jda.internal.interactions;

import lib.javax.annotation.Nonnull;
import lib.javax.annotation.Nullable;
import lib.net.dv8tion.jda.api.entities.Message;
import lib.net.dv8tion.jda.api.entities.MessageChannel;
import lib.net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import lib.net.dv8tion.jda.api.utils.data.DataObject;
import lib.net.dv8tion.jda.internal.JDAImpl;
import lib.net.dv8tion.jda.internal.interactions.InteractionImpl;
import lib.net.dv8tion.jda.internal.requests.restaction.interactions.UpdateInteractionActionImpl;

public abstract class ComponentInteractionImpl
extends InteractionImpl
implements ComponentInteraction {
    protected final String customId;
    protected final Message message;
    protected final long messageId;

    public ComponentInteractionImpl(JDAImpl jda, DataObject data) {
        super(jda, data);
        this.customId = data.getObject("data").getString("custom_id");
        DataObject messageJson = data.getObject("message");
        this.messageId = messageJson.getUnsignedLong("id");
        this.message = messageJson.isNull("type") ? null : jda.getEntityBuilder().createMessage(messageJson);
    }

    @Override
    @Nonnull
    public MessageChannel getChannel() {
        return (MessageChannel)super.getChannel();
    }

    @Override
    @Nonnull
    public String getComponentId() {
        return this.customId;
    }

    @Override
    @Nullable
    public Message getMessage() {
        return this.message;
    }

    @Override
    public long getMessageIdLong() {
        return this.messageId;
    }

    @Override
    @Nonnull
    public UpdateInteractionActionImpl deferEdit() {
        return new UpdateInteractionActionImpl(this.hook);
    }
}

