/*
 * Decompiled with CFR 0.152.
 */
package lib.net.dv8tion.jda.internal.handle;

import lib.net.dv8tion.jda.api.JDA;
import lib.net.dv8tion.jda.api.entities.StageInstance;
import lib.net.dv8tion.jda.api.events.stage.StageInstanceDeleteEvent;
import lib.net.dv8tion.jda.api.utils.data.DataObject;
import lib.net.dv8tion.jda.internal.JDAImpl;
import lib.net.dv8tion.jda.internal.entities.GuildImpl;
import lib.net.dv8tion.jda.internal.entities.StageChannelImpl;
import lib.net.dv8tion.jda.internal.handle.EventCache;
import lib.net.dv8tion.jda.internal.handle.SocketHandler;

public class StageInstanceDeleteHandler
extends SocketHandler {
    public StageInstanceDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        long guildId = content.getUnsignedLong("guild_id", 0L);
        if (this.getJDA().getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(guildId);
        if (guild == null) {
            EventCache.LOG.debug("Caching STAGE_INSTANCE_DELETE for uncached guild with id {}", (Object)guildId);
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, guildId, this.responseNumber, this.allContent, this::handle);
            return null;
        }
        long channelId = content.getUnsignedLong("channel_id", 0L);
        StageChannelImpl channel = (StageChannelImpl)guild.getStageChannelById(channelId);
        if (channel == null) {
            return null;
        }
        StageInstance instance = channel.getStageInstance();
        channel.setStageInstance(null);
        if (instance != null) {
            this.getJDA().handleEvent(new StageInstanceDeleteEvent((JDA)this.getJDA(), this.responseNumber, instance));
        }
        return null;
    }
}

