/*
 * Decompiled with CFR 0.152.
 */
package lib.net.dv8tion.jda.internal.entities;

import java.time.OffsetDateTime;
import java.util.EnumSet;
import lib.javax.annotation.Nonnull;
import lib.net.dv8tion.jda.api.Permission;
import lib.net.dv8tion.jda.api.entities.Guild;
import lib.net.dv8tion.jda.api.entities.GuildChannel;
import lib.net.dv8tion.jda.api.entities.StageChannel;
import lib.net.dv8tion.jda.api.entities.StageInstance;
import lib.net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import lib.net.dv8tion.jda.api.managers.StageInstanceManager;
import lib.net.dv8tion.jda.api.requests.RestAction;
import lib.net.dv8tion.jda.api.utils.data.DataObject;
import lib.net.dv8tion.jda.internal.managers.StageInstanceManagerImpl;
import lib.net.dv8tion.jda.internal.requests.RestActionImpl;
import lib.net.dv8tion.jda.internal.requests.Route;

public class StageInstanceImpl
implements StageInstance {
    private final long id;
    private StageChannel channel;
    private StageInstanceManager manager;
    private String topic;
    private StageInstance.PrivacyLevel privacyLevel;
    private boolean discoverable;

    public StageInstanceImpl(long id, StageChannel channel) {
        this.id = id;
        this.channel = channel;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.getChannel().getGuild();
    }

    @Override
    @Nonnull
    public StageChannel getChannel() {
        StageChannel real = this.channel.getJDA().getStageChannelById(this.channel.getIdLong());
        if (real != null) {
            this.channel = real;
        }
        return this.channel;
    }

    @Override
    @Nonnull
    public String getTopic() {
        return this.topic;
    }

    @Override
    @Nonnull
    public StageInstance.PrivacyLevel getPrivacyLevel() {
        return this.privacyLevel;
    }

    @Override
    public boolean isDiscoverable() {
        return this.discoverable;
    }

    @Override
    @Nonnull
    public RestAction<Void> delete() {
        this.checkPermissions();
        Route.CompiledRoute route = Route.StageInstances.DELETE_INSTANCE.compile(this.channel.getId());
        return new RestActionImpl<Void>(this.channel.getJDA(), route);
    }

    @Override
    @Nonnull
    public RestAction<Void> requestToSpeak() {
        Guild guild = this.getGuild();
        Route.CompiledRoute route = Route.Guilds.UPDATE_VOICE_STATE.compile(guild.getId(), "@me");
        DataObject body = DataObject.empty().put("channel_id", this.channel.getId());
        if (guild.getSelfMember().hasPermission((GuildChannel)this.getChannel(), Permission.VOICE_MUTE_OTHERS)) {
            body.putNull("request_to_speak_timestamp").put("suppress", false);
        } else {
            body.put("request_to_speak_timestamp", OffsetDateTime.now().toString());
        }
        if (!this.channel.equals(guild.getSelfMember().getVoiceState().getChannel())) {
            throw new IllegalStateException("Cannot request to speak without being connected to the stage channel!");
        }
        return new RestActionImpl<Void>(this.channel.getJDA(), route, body);
    }

    @Override
    @Nonnull
    public RestAction<Void> cancelRequestToSpeak() {
        Guild guild = this.getGuild();
        Route.CompiledRoute route = Route.Guilds.UPDATE_VOICE_STATE.compile(guild.getId(), "@me");
        DataObject body = DataObject.empty().putNull("request_to_speak_timestamp").put("suppress", true).put("channel_id", this.channel.getId());
        if (!this.channel.equals(guild.getSelfMember().getVoiceState().getChannel())) {
            throw new IllegalStateException("Cannot cancel request to speak without being connected to the stage channel!");
        }
        return new RestActionImpl<Void>(this.channel.getJDA(), route, body);
    }

    @Override
    @Nonnull
    public StageInstanceManager getManager() {
        this.checkPermissions();
        if (this.manager == null) {
            this.manager = new StageInstanceManagerImpl(this);
        }
        return this.manager;
    }

    public StageInstanceImpl setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public StageInstanceImpl setPrivacyLevel(StageInstance.PrivacyLevel privacyLevel) {
        this.privacyLevel = privacyLevel;
        return this;
    }

    public StageInstanceImpl setDiscoverable(boolean discoverable) {
        this.discoverable = discoverable;
        return this;
    }

    private void checkPermissions() {
        EnumSet<Permission> permissions = this.getGuild().getSelfMember().getPermissions(this.getChannel());
        EnumSet<Permission> required = EnumSet.of(Permission.MANAGE_CHANNEL, Permission.VOICE_MUTE_OTHERS, Permission.VOICE_MOVE_OTHERS);
        for (Permission perm : required) {
            if (permissions.contains((Object)perm)) continue;
            throw new InsufficientPermissionException(this.getChannel(), perm, "You must be a stage moderator to manage a stage instance! Missing Permission: " + (Object)((Object)perm));
        }
    }
}

