/*
 * Decompiled with CFR 0.152.
 */
package lib.net.dv8tion.jda.api.interactions.components.selections;

import lib.javax.annotation.CheckReturnValue;
import lib.javax.annotation.Nonnull;
import lib.javax.annotation.Nullable;
import lib.net.dv8tion.jda.api.entities.Emoji;
import lib.net.dv8tion.jda.api.utils.data.DataObject;
import lib.net.dv8tion.jda.api.utils.data.SerializableData;
import lib.net.dv8tion.jda.internal.utils.Checks;

public class SelectOption
implements SerializableData {
    private final String label;
    private final String value;
    private final String description;
    private final boolean isDefault;
    private final Emoji emoji;

    protected SelectOption(@Nonnull String label, @Nonnull String value) {
        this(label, value, null, false, null);
    }

    protected SelectOption(@Nonnull String label, @Nonnull String value, @Nullable String description, boolean isDefault, @Nullable Emoji emoji) {
        Checks.notEmpty(label, "Label");
        Checks.notEmpty(value, "Value");
        Checks.notLonger(label, 25, "Label");
        Checks.notLonger(value, 100, "Value");
        if (description != null) {
            Checks.notLonger(description, 50, "Description");
        }
        this.label = label;
        this.value = value;
        this.description = description;
        this.isDefault = isDefault;
        this.emoji = emoji;
    }

    @Nonnull
    @CheckReturnValue
    public static SelectOption of(@Nonnull String label, @Nonnull String value) {
        return new SelectOption(label, value);
    }

    @Nonnull
    @CheckReturnValue
    public SelectOption withLabel(@Nonnull String label) {
        return new SelectOption(label, this.value, this.description, this.isDefault, this.emoji);
    }

    @Nonnull
    @CheckReturnValue
    public SelectOption withValue(@Nonnull String value) {
        return new SelectOption(this.label, value, this.description, this.isDefault, this.emoji);
    }

    @Nonnull
    @CheckReturnValue
    public SelectOption withDescription(@Nullable String description) {
        return new SelectOption(this.label, this.value, description, this.isDefault, this.emoji);
    }

    @Nonnull
    @CheckReturnValue
    public SelectOption withDefault(boolean isDefault) {
        return new SelectOption(this.label, this.value, this.description, isDefault, this.emoji);
    }

    @Nonnull
    @CheckReturnValue
    public SelectOption withEmoji(@Nullable Emoji emoji) {
        return new SelectOption(this.label, this.value, this.description, this.isDefault, emoji);
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Nullable
    public Emoji getEmoji() {
        return this.emoji;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject object = DataObject.empty();
        object.put("label", this.label);
        object.put("value", this.value);
        object.put("default", this.isDefault);
        if (this.emoji != null) {
            object.put("emoji", this.emoji);
        }
        if (this.description != null && !this.description.isEmpty()) {
            object.put("description", this.description);
        }
        return object;
    }

    @Nonnull
    @CheckReturnValue
    public static SelectOption fromData(@Nonnull DataObject data) {
        Checks.notNull(data, "DataObject");
        return new SelectOption(data.getString("label"), data.getString("value"), data.getString("description", null), data.getBoolean("default", false), data.optObject("emoji").map(Emoji::fromData).orElse(null));
    }
}

