/*
 * Decompiled with CFR 0.152.
 */
package lib.net.dv8tion.jda.api.interactions.components;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lib.javax.annotation.Nonnull;
import lib.javax.annotation.Nullable;
import lib.net.dv8tion.jda.api.interactions.components.Button;
import lib.net.dv8tion.jda.api.interactions.components.Component;
import lib.net.dv8tion.jda.api.utils.data.SerializableData;
import lib.net.dv8tion.jda.internal.utils.Checks;

public interface ComponentLayout
extends SerializableData,
Iterable<Component> {
    @Nonnull
    public List<Component> getComponents();

    @Nonnull
    public List<Button> getButtons();

    @Nonnull
    public Type getType();

    default public boolean isEmpty() {
        return this.getComponents().isEmpty();
    }

    default public boolean isValid() {
        if (this.isEmpty()) {
            return false;
        }
        List<Component> components = this.getComponents();
        Map<Component.Type, List<Component>> groups = components.stream().collect(Collectors.groupingBy(Component::getType));
        if (groups.size() > 1) {
            return false;
        }
        for (Map.Entry<Component.Type, List<Component>> entry : groups.entrySet()) {
            Component.Type type = entry.getKey();
            List<Component> list = entry.getValue();
            if (list.size() <= type.getMaxPerRow()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    default public Component updateComponent(@Nonnull String id, @Nullable Component newComponent) {
        Checks.notNull(id, "ID");
        List<Component> list = this.getComponents();
        ListIterator<Component> it = list.listIterator();
        while (it.hasNext()) {
            Component component = it.next();
            if (!id.equals(component.getId()) && (!(component instanceof Button) || !id.equals(((Button)component).getUrl()))) continue;
            if (newComponent == null) {
                it.remove();
            } else {
                it.set(newComponent);
            }
            return component;
        }
        return null;
    }

    public static boolean updateComponent(@Nonnull List<? extends ComponentLayout> layouts, @Nonnull String id, @Nullable Component newComponent) {
        Checks.notNull(layouts, "ComponentLayout");
        Checks.notEmpty(id, "ID or URL");
        Iterator<? extends ComponentLayout> it = layouts.iterator();
        while (it.hasNext()) {
            ComponentLayout components = it.next();
            Component oldComponent = components.updateComponent(id, newComponent);
            if (oldComponent == null) continue;
            if (components.getComponents().isEmpty()) {
                it.remove();
            } else if (!components.isValid() && newComponent != null) {
                throw new IllegalArgumentException("Cannot replace " + (Object)((Object)oldComponent.getType()) + " with " + (Object)((Object)newComponent.getType()) + " due to a violation of the layout maximum. The resulting ComponentLayout is invalid!");
            }
            return !Objects.equals(oldComponent, newComponent);
        }
        return false;
    }

    public static enum Type {
        UNKNOWN(-1),
        ACTION_ROW(1);

        private final int key;

        private Type(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }
    }
}

